Stuff I need to keep looking up all the time...


https://stackoverflow.com/questions/55108794/what-is-the-difference-between-pairs-and-ipairs-in-lua

ipairs() and pairs() are slightly different, as you can see in the reference manual. A less technical description could be that:

 - ipairs() returns index-value pairs and is mostly used for numeric tables. The non-numeric keys are ignored as a whole, similar to numeric indices less than 1. In addition, gaps in between the indices lead to halts. The ordering is deterministic, by numeric magnitude.

 - pairs() returns key-value pairs and is mostly used for associative tables. All keys are preserved, but the order is unspecified.

```lua
-- Only include positive keys in order
for key, value in ipairs(u) do 
    print(key, value) 
end

-- Includes non-numberic keys as well as 0 or less
for key, value in pairs(u) do 
    print(key, value) 
end
```


Add to a list:

```
local monster_name_list = {}

for _, monster in pairs(MK) do
  table.insert(monster_name_list, monster.n)
end
```

Get length of numeric list:

```
local len = #monster_name_list
```
