-- Sound tables
mg_mapgen = {}

local mod_path = minetest.get_modpath("mg_mapgen")

dofile(mod_path.."/nodes.lua")
dofile(mod_path.."/schematics/apple_tree.lua")

core.set_mapgen_setting("mg_flags", "nocaves,nodungeons,light,decorations", true)

local hard_sounds = {
	footstep = {name = "hard_footstep", gain = 0.3},
	dig = {name = "dig_cracky", gain = 0.5},
	dug = {name = "hard_footstep", gain = 1.0},
	place = {name = "place_node_hard", gain = 1.0},
}

mg_mapgen.hard_sounds = hard_sounds

local hard_sounds_digimm = {
	footstep = {name = "hard_footstep", gain = 0.3},
	dig = {name = "dig_dig_immediate", gain = 0.5},
	dug = {name = "hard_footstep", gain = 1.0},
	place = {name = "place_node_hard", gain = 1.0},
}

local soft_sounds = {
	footstep = {name = "dirt_footstep", gain = 0.4},
	dig = {name = "dig_crumbly", gain = 0.5},
	dug = {name = "dirt_footstep", gain = 1.0},
	place = {name = "place_node", gain = 1.0},
}

local water_sounds = {
	footstep = {name = "water_footstep", gain = 0.2},
}


-- Register terrain nodes

minetest.register_node("mg_mapgen:stone", {
	description = "Stone",
	tiles = {"mapgen_stone.png"},
	groups = {cracky = 3, opaque = 1},
	sounds = hard_sounds,
})


minetest.register_node("mg_mapgen:mossycobble", {
	description = "Mossy Cobble Stone",
	tiles = {"mapgen_mossycobble.png"},
	groups = {cracky = 3, opaque = 1},
	sounds = hard_sounds,
})

minetest.register_node("mg_mapgen:cobble", {
	description = "Cobble Stone",
	tiles = {"mapgen_cobble.png"},
	groups = {cracky = 3, opaque = 1},
	sounds = hard_sounds,
})

minetest.register_node("mg_mapgen:grass", {
	description = "Grass",
	tiles = {
    "mapgen_grass.png",
    "mapgen_dirt.png",
    { name = "mapgen_dirt.png^mapgen_grass_side.png", tileable_vertical = false}},
	groups = {},
  drop = "mg_mapgen:dirt",
	sounds = soft_sounds,
})

minetest.register_node("mg_mapgen:dirt", {
	description = "Dirt",
	tiles = {"mapgen_dirt.png"},
	groups = {opaque = 1},
	sounds = soft_sounds,
})

minetest.register_node("mg_mapgen:sand", {
	description = "Sand",
	tiles = {"mapgen_sand.png"},
	groups = {crumbly = 3, falling_node = 1, sand = 1, opaque = 1},
	sounds = soft_sounds,
	drop = "",
})


-- Register dungeon nodes

minetest.register_node("mg_mapgen:blackstone", {
	description = "Black Stone",
	tiles = {"mcl_blackstone_top.png"},
	is_ground_content = false,
	groups = {cracky = 3, opaque = 1},
	sounds = hard_sounds_digimm,
})

minetest.register_node("mg_mapgen:chasm_edge", {
	description = "Chasm Edge",
	tiles = {"mcl_blackstone_basalt_smooth.png"},
	is_ground_content = false,
	groups = {cracky = 3, opaque = 1},
	sounds = hard_sounds_digimm,
})

minetest.register_node("mg_mapgen:stone_block", {
	description = "Stone Block",
	tiles = {"mapgen_stone_block.png"},
	is_ground_content = false,
	groups = {cracky = 3, opaque = 1},
	sounds = hard_sounds_digimm,
})

minetest.register_node("mg_mapgen:stone_block_stair", {
	description = "Stone Block Stair",
	drawtype = "nodebox",
	tiles = {
		"mapgen_stone_block_divided.png",
		"mapgen_stone_block.png",
		"mapgen_stone_block_divided.png"
	},
	paramtype = "light",
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {cracky = 3},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.5, -0.5, -0.5, 0.5, 0.0, 0.5},
			{-0.5, 0.0, 0.0, 0.5, 0.5, 0.5},
		},
	},
	sounds = hard_sounds_digimm,
})


local creative_mode_cache = minetest.settings:get_bool("creative_mode")

-- Register water nodes

minetest.register_node("mg_mapgen:water_source", {
	description = "Water Source",
	drawtype = "liquid",
  waving = 3,
	tiles = {
		{
			name = "mapgen_water_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "mapgen_water_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "mg_mapgen:water_flowing",
	liquid_alternative_source = "mg_mapgen:water_source",
	liquid_viscosity = 1,
	post_effect_color = {a = 103, r = 30, g = 60, b = 90},
	groups = {water = 1, puts_out_fire = 1},
	sounds = water_sounds,
})

minetest.register_node("mg_mapgen:water_flowing", {
	description = "Flowing Water",
	drawtype = "flowingliquid",
  waving = 3,
	tiles = {"mapgen_water.png"},
	special_tiles = {
		{
			name = "mapgen_water_flowing_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "mapgen_water_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "mg_mapgen:water_flowing",
	liquid_alternative_source = "mg_mapgen:water_source",
	liquid_viscosity = 1,
	liquid_range = 2,
	post_effect_color = {a = 103, r = 30, g = 60, b = 90},
	groups = {water = 1, puts_out_fire = 1},
	sounds = water_sounds,
})


-- Register river water nodes

-- This is an alternative water node required by mapgens with sloping rivers.
-- It has 'liquid_renewable = false' and a short 'liquid_range' to avoid
-- overflowing riverbanks.

minetest.register_node("mg_mapgen:river_water_source", {
	description = "River Water Source",
	drawtype = "liquid",
	tiles = {
		{
			name = "mapgen_river_water.png",
			backface_culling = false,
		},
		{
			name = "mapgen_river_water.png",
			backface_culling = true,
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "mg_mapgen:river_water_flowing",
	liquid_alternative_source = "mg_mapgen:river_water_source",
	liquid_viscosity = 1,
	liquid_renewable = false,
	liquid_range = 2,
	post_effect_color = {a = 103, r = 30, g = 76, b = 90},
	groups = {water = 1, puts_out_fire = 1},
	sounds = water_sounds,
})

minetest.register_node("mg_mapgen:river_water_flowing", {
	description = "Flowing River Water",
	drawtype = "flowingliquid",
	tiles = {"mapgen_river_water.png"},
	special_tiles = {
		{
			name = "mapgen_river_water.png",
			backface_culling = false,
		},
		{
			name = "mapgen_river_water.png",
			backface_culling = false,
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "mg_mapgen:river_water_flowing",
	liquid_alternative_source = "mg_mapgen:river_water_source",
	liquid_viscosity = 1,
	liquid_renewable = false,
	liquid_range = 2,
	post_effect_color = {a = 103, r = 30, g = 76, b = 90},
	groups = {water = 1, puts_out_fire = 1},
	sounds = water_sounds,
})


-- Register magma nodes

minetest.register_node("mg_mapgen:magma_source", {
	description = "Magma Source",
	drawtype = "liquid",
	tiles = {
		{
			name = "mapgen_magma_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.0,
			},
		},
		{
			name = "mapgen_magma_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.0,
			},
		},
	},
	paramtype = "light",
	light_source = 13,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "mg_mapgen:magma_flowing",
	liquid_alternative_source = "mg_mapgen:magma_source",
	liquid_viscosity = 3,
	liquid_renewable = false,
	damage_per_second = 4 * 2,
	post_effect_color = {a = 191, r = 255, g = 64, b = 0},
  groups = {set_on_fire = 7}
})

minetest.register_node("mg_mapgen:magma_flowing", {
	description = "Flowing Magma",
	drawtype = "flowingliquid",
	tiles = {"mapgen_magma.png"},
	special_tiles = {
		{
			name = "mapgen_magma_flowing_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.3,
			},
		},
		{
			name = "mapgen_magma_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.3,
			},
		},
	},
	paramtype = "light",
	paramtype2 = "flowingliquid",
	light_source = 13,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "mg_mapgen:magma_flowing",
	liquid_alternative_source = "mg_mapgen:magma_source",
	liquid_viscosity = 3,
	liquid_renewable = false,
	damage_per_second = 4 * 2,
	liquid_range = 2,
	post_effect_color = {a = 191, r = 255, g = 64, b = 0},
	groups = {not_in_creative_inventory = 1, set_on_fire = 7},
})

minetest.register_node("mg_mapgen:dry_grass", {
	description = "Dry Grass",
	drawtype = "plantlike",
	waving = 1,
	tiles = {"mapgen_dry_grass.png"},
	-- Use texture of a taller grass stage in inventory
	inventory_image = "mapgen_dry_grass.png",
	wield_image = "mapgen_dry_grass.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	pointable = false,
	buildable_to = true,
	groups = {snappy = 3, flora = 1, attached_node = 1, grass = 1,
		normal_grass = 1, flammable = 1, replaced_by_lichen = 1},
	sounds = soft_sounds,
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, -5 / 16, 6 / 16},
	}
})

minetest.register_node("mg_mapgen:grass_1", {
	description = "Grass",
	drawtype = "plantlike",
	waving = 1,
	tiles = {"mapgen_grass_1.png"},
	-- Use texture of a taller grass stage in inventory
	inventory_image = "mapgen_grass_3.png",
	wield_image = "mapgen_grass_3.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	pointable = false,
	buildable_to = true,
	groups = {snappy = 3, flora = 1, attached_node = 1, grass = 1,
		normal_grass = 1, flammable = 1, replaced_by_lichen = 1},
	sounds = soft_sounds,
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, -5 / 16, 6 / 16},
	}
})

for i = 2, 5 do
	minetest.register_node("mg_mapgen:grass_" .. i, {
		description = "Grass",
		drawtype = "plantlike",
		waving = 1,
		tiles = {"mapgen_grass_" .. i .. ".png"},
		inventory_image = "mapgen_grass_" .. i .. ".png",
		wield_image = "mapgen_grass_" .. i .. ".png",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
	  pointable = false,
		buildable_to = true,
		drop = "mg_mapgen:grass_1",
		groups = {snappy = 3, flora = 1, attached_node = 1,
			not_in_creative_inventory = 1, grass = 1,
			normal_grass = 1, flammable = 1, replaced_by_lichen = 1},
		sounds = soft_sounds,
		selection_box = {
			type = "fixed",
			fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, -3 / 16, 6 / 16},
		},
	})
end


-- Register aliases for map generators.
-- Tells engine mapgens which nodes to use for 'base terrain': the terrain
-- generated by an engine mapgen before biome nodes are applied.

minetest.register_alias("mapgen_stone", "mg_mapgen:stone")
minetest.register_alias("mapgen_water_source", "mg_mapgen:water_source")
minetest.register_alias("mapgen_river_water_source", "mg_mapgen:river_water_source")


-- Register biomes

-- Grassland biome stack

-- A 'biome stack' is a vertical stack of biomes all having the same heat and
-- humidity points, and therefore all having the same horizontal distribution.
-- In minipeli only one biome stack is registered, more will probably be
-- desired for a developed game.

-- Dry land from beach top to world top

minetest.register_biome({
	name = "grassland",
	node_top = "mg_mapgen:grass",
	depth_top = 1,
	node_filler = "mg_mapgen:dirt",
	depth_filler = 1,
	node_riverbed = "mg_mapgen:sand",
	depth_riverbed = 2,
	node_cave_liquid = "mg_mapgen:water_source",
	node_dungeon = "mg_mapgen:stone_block",
	node_dungeon_stair = "mg_mapgen:stone_block_stair",
	y_max = 31000,
	y_min = 4,
	heat_point = 50,
	humidity_point = 50,
})

-- The sand of beaches and seabeds

minetest.register_biome({
	name = "grassland_sea",
	node_top = "mg_mapgen:sand",
	depth_top = 1,
	node_filler = "mg_mapgen:sand",
	depth_filler = 2,
	node_riverbed = "mg_mapgen:sand",
	depth_riverbed = 2,
	node_cave_liquid = "mg_mapgen:water_source",
	node_dungeon = "mg_mapgen:stone_block",
	node_dungeon_stair = "mg_mapgen:stone_block_stair",
	vertical_blend = 1,
	y_max = 3,
	y_min = -127,
	heat_point = 50,
	humidity_point = 50,
})

-- Shallow underground

minetest.register_biome({
	name = "grassland_under",
	node_cave_liquid = "mg_mapgen:water_source",
	node_dungeon = "mg_mapgen:stone_block",
	node_dungeon_stair = "mg_mapgen:stone_block_stair",
	y_max = -128,
	y_min = -512,
	heat_point = 50,
	humidity_point = 50,
})

-- Deep underground where magma first appears

minetest.register_biome({
	name = "grassland_deep",
	node_cave_liquid = {"mg_mapgen:water_source", "mg_mapgen:magma_source"},
	node_dungeon = "mg_mapgen:stone_block",
	node_dungeon_stair = "mg_mapgen:stone_block_stair",
	y_max = -512,
	y_min = -31000,
	heat_point = 50,
	humidity_point = 50,
})

local function register_grass_decoration(offset, scale, length)
	minetest.register_decoration({
		name = "mg_mapgen:grass_" .. length,
		deco_type = "simple",
		place_on = {"mg_mapgen:grass"},
		sidelen = 16,
		noise_params = {
			offset = offset,
			scale = scale,
			spread = {x = 200, y = 200, z = 200},
			seed = 329,
			octaves = 3,
			persist = 0.6
		},
		biomes = {"grassland", "grassland_sea"},
		y_max = 31000,
		y_min = 1,
		decoration = "mg_mapgen:grass_" .. length,
	})
end

register_grass_decoration(-0.03,  0.09,  5)
register_grass_decoration(-0.015, 0.075, 4)
register_grass_decoration(0,      0.06,  3)
register_grass_decoration(0.0105,  0.045, 2)
register_grass_decoration(0.03,   0.03,  1)


minetest.register_decoration({
  name = "mg_mapgen:tree",
  deco_type = "schematic",
  place_on = {"mg_mapgen:grass"},
  biomes = {"grassland"},
  schematic = mg_mapgen.apple_tree,
  sidelen = 16,
  noise_params = {
    offset = 0,
    scale = 0.002,
    spread = {x = 250, y = 250, z = 250},
    seed = 2,
    octaves = 3,
    persist = 0.66
  },
  y_max = 31000,
  y_min = 1,
  flags = "place_center_x, place_center_z",
  rotation = "random",
})


