local mod_path = minetest.get_modpath("mg_mobs")
local spawn = dofile(mod_path.."/spawn.lua")
local bolts = dofile(mod_path.."/ai_bolts.lua")

local function clamp(x, low, high)
  return math.min(high, math.max(x, low))
end

local function rand_percent(percent)
  return math.random(0,99) < clamp(percent, 0, 100)
end

function mg_mobs.hq_runfrom(self,prty,tgtobj, dist)
  local init=true
  dist = dist or self.view_range*1.1
  local func = function(self)
    if not mobkit.is_alive(tgtobj) then return true end
    if init then
      mobkit.make_sound(self,'scared')
      init=false
      return
    end

    if mobkit.is_queue_empty_low(self) and self.isonground then
      local pos = mobkit.get_stand_pos(self)
      local opos = tgtobj:get_pos()
      if vector.distance(pos,opos) < dist then
        local tpos = {x=2*pos.x - opos.x,
        y=opos.y,
        z=2*pos.z - opos.z}
        mobkit.goto_next_waypoint(self,tpos)
      else
        self.object:set_velocity({x=0,y=0,z=0})
        return true
      end
    end
  end
  mobkit.queue_high(self,func,prty)
end

local function can_punch(mob_pos, target_pos, target)
  -- only nodes - no object or liques
  local cast = core.raycast(mob_pos, target_pos, true, false)
  local thing = cast:next()
  while thing do
    if thing.type == "node" then
      local node = core.get_node(thing.intersection_point)
      local def = minetest.registered_nodes[node.name]
      -- A walkable node is a solid node
      if def and def.walkable then
        return false
      end
    end
    if thing.type == "object" and thing.ref == target then
      return true
    end
    thing = cast:next()
  end
  return false
end


local function lq_jumpattack(self,height,target)
  local init=true
  local func=function(self)
    if not mobkit.is_alive(target) then return true end
    if self.isonground then
      -- start jump towards target
      if init then
        local dir = minetest.yaw_to_dir(self.object:get_yaw())
        dir=vector.multiply(dir, self.max_speed)
        dir.y = -mobkit.gravity*math.sqrt(height*2/-mobkit.gravity)
        self.object:set_velocity(dir)
        mobkit.make_sound(self,'charge')
        init=false
      else
        -- Missed the attack
        mobkit.lq_idle(self,0.1)
        return true
      end
    else

      local pos = self.object:get_pos()
      -- calculate attack spot
      local yaw = self.object:get_yaw()
      local dir = minetest.yaw_to_dir(yaw)
      local apos = mobkit.pos_translate2d(pos,yaw,self.attack.range)

      -- mob hit target
      if can_punch(pos, apos, target) then	--bite
        target:punch(self.object,1,self.attack)
        -- bounce off
        local vy = self.object:get_velocity().y
        self.object:set_velocity({x=dir.x*-3,y=vy,z=dir.z*-3})
        -- play attack sound if defined
        mobkit.make_sound(self,'attack')
        return true
      end
    end
  end
  mobkit.queue_low(self,func)
end

local function hq_attack(self,prty,tgtobj)
  local func = function(self)
    if not mobkit.is_alive(tgtobj) then return true end
    if mobkit.is_queue_empty_low(self) then
      local pos = mobkit.get_stand_pos(self)
      local tpos = mobkit.get_stand_pos(tgtobj)
      local dist = vector.distance(pos,tpos)
      -- not close enough, go back to hunting
      if dist > 3 then
        return true
      else
        mobkit.lq_turn2pos(self,tpos)
        local height = tgtobj:is_player() and 0.35 or tgtobj:get_luaentity().height*0.6
        if tpos.y+height > pos.y then
          lq_jumpattack(self,tpos.y+height-pos.y,tgtobj)
        else
          -- This is confusing
          mobkit.lq_dumbwalk(
            self,
            mobkit.pos_shift(tpos,{x=math.random()-0.5,z=math.random()-0.5})
          )
        end
      end
    end
  end
  mobkit.queue_high(self,func,prty)
end

local function hq_swimto_tgt(self,prty, tgtobj)
	local box = self.object:get_properties().collisionbox
	local cols = {}
	local func = function(self)
		if not self.isinliquid then
			if self.isonground then return true end
			return false
		end

    local tpos = tgtobj:get_pos()

		local pos = mobkit.get_stand_pos(self)
		local y = self.object:get_velocity().y
		local pos2d = {x=pos.x,y=tpos.y,z=pos.z}
		local dir = vector.normalize(vector.direction(pos2d,tpos))
		local yaw = minetest.dir_to_yaw(dir)

    local dist = vector.distance(pos,tpos)

    -- Attack if close enough
    if dist < 3 then
      hq_attack(self, prty+1, tgtobj)
      return
    end

    -- once a second check to see if can
    -- jump out of water
		if mobkit.timer(self,1) then
			cols = mobkit.get_box_displace_cols(pos,box,dir,1)
			for _,p in ipairs(cols[1]) do
				p.y=pos.y
				local h = mobkit.get_terrain_height(p)
				if h and h>pos.y and self.isinliquid then
					mobkit.lq_freejump(self)
					break
				end
			end
		elseif mobkit.turn2yaw(self,yaw) then
			dir.y = y
			self.object:set_velocity(dir)
		end

    -- if get close enough, should punch the target
    -- right now if the mob is in the water it won't punch you
	end
	mobkit.queue_high(self,func,prty)
end

local function check_stealth(self, dist, stealth_range)
  if mobkit.timer(self,1) then
    if dist >= stealth_range * 2 and rand_percent(3) then
      return true
    end
    if dist > stealth_range * 3 then
      return true
    end
  end
end


local function use_abilities(self)
  self.ability_timer = self.ability_timer or 0
  self.ability_timer = self.ability_timer + self.dtime
  if self.ability_timer < 1 then
    return
  end
  self.ability_timer = 0

  if self.bolts and #self.bolts > 0 then
    -- TODO - if cast spells slowly, then only cast every other turn
    -- instead of every turn as it is now
    local did_shoot = bolts.shoot_bolts(self)
    if did_shoot then
      mobkit.make_sound(self,'warn')
      -- return so dont summon and shoot on same turn
      return
    end
  end
  -- if monster didn't shoot and they can summon, let them try that now
  if self.abilities and self.abilities.cast_summon then
    spawn.summon_horde(self)
  end
end

function mg_mobs.hq_hunt(self, prty, tgtobj)
  local func = function(self)
    if not mobkit.is_alive(tgtobj) then return true end
    if mobkit.is_queue_empty_low(self) then
      local pos = mobkit.get_stand_pos(self)
      local opos = tgtobj:get_pos()
      local dist = vector.distance(pos,opos)

      local stealth_range = mg_stealth.get_stealth(tgtobj)

      local end_hunting = check_stealth(self, dist, stealth_range)
      if end_hunting then
        return true
      end

      use_abilities(self)

      local maintains_distance = self.behaviors and self.behaviors.maintains_distance

      if self.isinliquid then
        -- this gets a little weird
        hq_swimto_tgt(self, prty+1, tgtobj)
      -- check every step
      elseif maintains_distance and dist > 5 and self.isonground then
        mobkit.goto_next_waypoint(self,opos)
      elseif maintains_distance and dist < 3 and self.isonground then
        -- want to go away from target
        mg_mobs.hq_runfrom(self, prty+1, tgtobj, 4)
      -- if between 3 - 5 blocks away, then chill out
      elseif maintains_distance and self.isonground then
        -- turn to face player if not facing
        -- then chill out
        local yaw = self.object:get_yaw()
        local tyaw = minetest.dir_to_yaw(vector.direction(pos,opos))
        if math.abs(tyaw-yaw) > 1 then
          mobkit.lq_turn2pos(self,opos)
          mobkit.lq_idle(self,0.1)
          return
        end
        -- if already facing player, chill out
				mobkit.lq_idle(self,0.1)
        return
      elseif dist > 3 and self.isonground then
        mobkit.goto_next_waypoint(self,opos)
      elseif self.isonground then
        hq_attack(self, prty+1, tgtobj)
      end
    end
  end
  mobkit.queue_high(self,func,prty)
end

