minetest.register_entity("mg_mobs:spider",{
  -- common props
  physical = true,
  stepheight = 0.1,				--EVIL!
  collide_with_objects = true,
  collisionbox = {-0.3, -0.01, -0.3, 0.3, 0.89, 0.3},
  visual = "mesh",
  mesh = "mobs_mc_spider.b3d",
  textures = {"mobs_mc_spider.png"},
  visual_size = {x = 1, y = 1},
  static_save = true,
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.9,
  net_drag = 0.1,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10,			-- seconds
  max_hp = 20,
  regen=20,
  defense = 70,
  accuracy = 90,
  attack={range=1,damage_groups={fleshy=3, flesh_max=4}},
  sounds = {
    warn = 'mobs_mc_spider_attack',
    hurt = 'mobs_mc_spider_hurt',
  },
  animation = {
    walk={range={x=0,y=20},speed=25,loop=true},
    run={range={x=0,y=20},speed=50,loop=true},
    stand={range={x=20,y=40},speed=10,loop=true},
  },
  bolts = { 'spiderweb' },
  behaviors = {
    immune_to_webs = 1,
    cast_spells_slowly = 1,
    always_use_ability = 1
  },
  abilities = {
    poisons = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:spider", "Spider", 1);
