local S = minetest.get_translator("pep")
local ppa = minetest.get_modpath("playerphysics")

pep = {}
function pep.register_potion(potiondef)
	local on_use
	if(potiondef.effect_type ~= nil) then
		on_use = function(itemstack, user, pointed_thing)
			playereffects.apply_effect_type(potiondef.effect_type, potiondef.duration, user)
			itemstack:take_item()
			return itemstack
		end
	else
		on_use = function(itemstack, user, pointed_thing)
			itemstack:take_item()
			return itemstack
		end
	end
	minetest.register_craftitem("pep:"..potiondef.basename, {
		description = S("@1", potiondef.contentstring),
    mg_help = potiondef.longdesc,
		_doc_items_longdesc = potiondef.longdesc,
		_doc_items_usagehelp = S("Hold it in your hand, then left-click to drink it."),
		inventory_image = "pep_"..potiondef.basename..".png",
		wield_image = "pep_"..potiondef.basename..".png",
		on_use = on_use,
    range = 1.5,
	})
end


local add_physic = function(player, attribute, value)
	if ppa then
		playerphysics.add_physics_factor(player, attribute, "pep:"..attribute, value)
	else
		player:set_physics_override({[attribute]=value})
	end
end
local remove_physic = function(player, attribute)
	if ppa then
		playerphysics.remove_physics_factor(player, attribute, "pep:"..attribute)
	else
		player:set_physics_override({[attribute]=1})
	end
end

local speed = player_monoids.speed
playereffects.register_effect_type("pepspeedplus", S("High speed"), "pep_speedplus.png", {"speed"},
	function(player)
    speed:add_change(player, 2, "pep:2x_speed")
	end,
	function(effect, player)
    speed:del_change(player, "pep:2x_speed")
	end
)
playereffects.register_effect_type("pepspeedminus", S("Low speed"), "pep_speedminus.png", {"speed"},
	function(player)
    speed:add_change(player, 0.5, "pep:half_speed")
	end,
	function(effect, player)
    speed:del_change(player, "pep:half_speed")
	end
)
playereffects.register_effect_type("pepspeedreset", S("Speed neutralizer"), "pep_speedreset.png", {"speed"},
	function() end, function() end)

playereffects.register_effect_type("pepjumpplus", S("High jump"), "pep_jumpplus.png", {"jump"},
	function(player)
		add_physic(player, "jump", 2)
	end,
	function(effect, player)
		remove_physic(player, "jump")
	end
)
playereffects.register_effect_type("pepjumpminus", S("Low jump"), "pep_jumpminus.png", {"jump"},
	function(player)
		add_physic(player, "jump", 0.5)
	end,
	function(effect, player)
		remove_physic(player, "jump")
	end
)
playereffects.register_effect_type("pepjumpreset", S("Jump height neutralizer"), "pep_jumpreset.png", {"jump"},
	function() end, function() end)




local gravity = player_monoids.gravity
playereffects.register_effect_type("pepgrav0", S("No gravity"), "pep_grav0.png", {"gravity"},
	function(player)
    gravity:add_change(player, -1, "pep:minus_gravity")
	end,
	function(effect, player)
    gravity:del_change(player, "pep:minus_gravity")
	end
)
playereffects.register_effect_type("pepgravreset", S("Gravity neutralizer"), "pep_gravreset.png", {"gravity"},
	function() end, function() end)
playereffects.register_effect_type("pepregen", S("Regeneration"), "pep_regen.png", {"health"},
	function(player)
		player:set_hp(player:get_hp()+1)
	end,
	nil, nil, nil, 2
)
playereffects.register_effect_type("pepregen2", S("Strong regeneration"), "pep_regen2.png", {"health"},
	function(player)
		player:set_hp(player:get_hp()+2)
	end,
	nil, nil, nil, 1
)




if minetest.get_modpath("mana") ~= nil then
	playereffects.register_effect_type("pepmanaregen", S("Weak mana boost"), "pep_manaregen.png", {"mana"},
		function(player)
			local name = player:get_player_name()
			mana.setregen(name, mana.getregen(name) + 0.5)
		end,
		function(effect, player)
			local name = player:get_player_name()
			mana.setregen(name, mana.getregen(name) - 0.5)
		end
	)
	playereffects.register_effect_type("pepmanaregen2", S("Strong mana boost"), "pep_manaregen2.png", {"mana"},
		function(player)
			local name = player:get_player_name()
			mana.setregen(name, mana.getregen(name) + 1)
		end,
		function(effect, player)
			local name = player:get_player_name()
			mana.setregen(name, mana.getregen(name) - 1)
		end
	)
end


playereffects.register_effect_type("pepbreath", S("Perfect breath"), "pep_breath.png", {"breath"},
	function(player)
		player:set_breath(player:get_breath()+2)
	end,
	nil, nil, nil, 1
)

playereffects.register_effect_type("weakness", "Weakness", "pep_speedminus.png", {"weakness"},
	function(player)
    mg_strength.set_weakness(player, 1)
	end,
	function(_effect, player)
    mg_strength.set_weakness(player, 0)
	end
)

playereffects.register_effect_type("invisibility", "Invisibility", "pep_speedminus.png", {"invisibility"},
	function(player)
    mg_stealth.set_invisible(player, 1)
	end,
	function(_effect, player)
    mg_stealth.set_invisible(player, 0)
	end
)

local fire_immunity = "mg_fire_immunity"
playereffects.register_effect_type("fire_immunity", "Fire Immunity", "pep_fire_immunity.png", {"fire_immunity"},
	function(player)
    local meta = player:get_meta()
    meta:set_int(fire_immunity, 1)
	end,
	function(_effect, player)
    local meta = player:get_meta()
    meta:set_int(fire_immunity, 0)
	end
)

pep.register_potion({
	basename = "invisibility",
	contentstring = "Invisibility",
	longdesc = "Drinking it will reduce your stealth range to 1, making it very difficult for monsters to see you.",
	effect_type = "invisibility",
	duration = 75,
})

pep.register_potion({
	basename = "fire_immunity",
	contentstring = "Fire Immunity",
	longdesc = "Drinking it will make you immune to damage from lava and fire for 30 seconds",
	effect_type = "fire_immunity",
	duration = 150,
})

pep.register_potion({
	basename = "speedplus",
	contentstring = S("Running Potion"),
	longdesc = S("Drinking it will make you run faster for 30 seconds."),
	effect_type = "pepspeedplus",
	duration = 30,
})

pep.register_potion({
	basename = "speedminus",
	contentstring = S("Slug Potion"),
	longdesc = S("Drinking it will make you walk slower for 30 seconds."),
	effect_type = "pepspeedminus",
	duration = 30,
})

pep.register_potion({
	basename = "speedreset",
	contentstring = S("Speed Neutralizer"),
	longdesc = S("Drinking it will stop all speed effects you may currently have."),
	effect_type = "pepspeedreset",
	duration = 0
})

pep.register_potion({
	basename = "breath",
	contentstring = S("Air Potion"),
	longdesc = S("Drinking it gives you breath underwater for 30 seconds."),
	effect_type = "pepbreath",
	duration = 30,
})

pep.register_potion({
	basename = "regen",
	contentstring = S("Weak Healing Potion"),
	longdesc = S("Drinking it makes you regenerate health. Every 2 seconds, you get 1 HP, 10 times in total."),
	effect_type = "pepregen",
	duration = 10,
})

pep.register_potion({
	basename = "regen2",
	contentstring = S("Strong Healing Potion"),
	longdesc = S("Drinking it makes you regenerate health quickly. Every second you get 2 HP, 10 times in total."),
	effect_type = "pepregen2",
	duration = 10,
})

pep.register_potion({
	basename = "grav0",
	contentstring = S("Levitation Potion"),
	longdesc = S("When you drink this potion, gravity stops affecting you, as if you were in space. The effect lasts for 20 seconds."),
	effect_type = "pepgrav0",
	duration = 20,
})

pep.register_potion({
	basename = "gravreset",
	contentstring = S("Gravity Neutralizer"),
	longdesc = S("Drinking it will stop all gravity effects you currently have."),
	effect_type = "pepgravreset",
	duration = 0,
})

pep.register_potion({
	basename = "jumpplus",
	contentstring = S("High Jumping Potion"),
	longdesc = S("Drinking it will make you jump higher for 30 seconds."),
	effect_type = "pepjumpplus",
	duration = 30,
})

pep.register_potion({
	basename = "jumpminus",
	contentstring = S("Low Jumping Potion"),
	longdesc = S("Drinking it will make you jump lower for 30 seconds."),
	effect_type = "pepjumpminus",
	duration = 30,
})

pep.register_potion({
	basename = "jumpreset",
	contentstring = S("Jump Neutralizer"),
	longdesc = S("Drinking it will stop all jumping effects you may currently have."),
	effect_type = "pepjumpreset",
	duration = 0,
})
