local rand_range = mg_arch.rand_range
local rand_percent = mg_arch.rand_percent

local registerItemCategory = mg_arch.item_api.registerItemCategory
local registerMgItem = mg_arch.item_api.registerMgItem



local goldblock = 'mg_mapgen:gold_pile_1'
local function on_gold_spawn (item, pos)
  core.set_node(pos, {name=goldblock})
  local meta = core.get_meta(pos)
  meta:set_int("gold", item.quantity)
  return item
end

local amulet = 'mg_game:crystal'
local function on_amulet_spawn (item, pos)
  core.set_node(pos, {name=amulet})
  return item
end

local chest = 'mg_chest:chest'
local function on_consumable_spawn (item, pos)
  core.set_node(pos, {name=chest})
  local loc = {type="node", pos=pos}
  local inv = core.get_inventory(loc)
  inv:add_item('main', item.node_name)
  return item
end

local function randWeaponEnchant()
  local enchant = 0
  if rand_percent(40) then
    enchant = enchant + rand_range(1,3)
    if rand_percent(50) then
      enchant = enchant * -1
    else
      while rand_percent(30) do
        enchant = enchant + 1
      end
    end
  end
  return enchant
end

local function add_weapon(inv, name, item)
  local stack = ItemStack(name)
  stack = mg_tools.enchant_weapon(stack, item.enchant1)
  if item.enchant1 < 0 then
    stack = mg_tools.curse_weapon(stack)
  end
  inv:add_item('main', stack)
end

local function on_weapon_spawn (item, pos)
  item.enchant1 = randWeaponEnchant()
  core.set_node(pos, {name=chest})
  local loc = {type="node", pos=pos}
  local inv = core.get_inventory(loc)

  if item.kind == 'arrow' or
     item.kind == 'fire arrow' or
     item.kind == 'steel arrow'
  then
    if item.kind == 'fire arrow' then
      item.quantity = rand_range(3,6)
    else
      item.quantity = rand_range(5,18)
    end
    local stack = ItemStack(item.node_name)
    stack:set_count(item.quantity)
    inv:add_item('main', stack)
    inv:add_item('main', 'bows:bow_wood')
  else
    add_weapon(inv, item.node_name, item)
  end
  return item
end


local function add_armor(inv, name, item)
  local stack = ItemStack(name)
  stack = mg_armor.enchant_armor(stack, item.enchant1)
  inv:add_item('main', stack)
end

local function on_armor_spawn (item, pos)
  item.enchant1 = randWeaponEnchant()
  core.set_node(pos, {name=chest})
  local loc = {type="node", pos=pos}
  local inv = core.get_inventory(loc)

  add_armor(inv, item.node_name, item)
  return item
end

local function add_ring(inv, name, item)
  local stack = ItemStack(name)
  stack = mg_rings.enchant_ring(stack, item.enchant1)
  inv:add_item('main', stack)
end

local function on_ring_spawn (item, pos)
  item.enchant1 = rand_range(1,3)

  if rand_percent(16) then
    item.enchant1 = item.enchant1 * -1;
  else
    while rand_percent(10) do
      item.enchant1 = item.enchant1 + 1;
    end
  end

  core.set_node(pos, {name=chest})
  local loc = {type="node", pos=pos}
  local inv = core.get_inventory(loc)

  add_ring(inv, item.node_name, item)
  return item
end

local function add_staff(inv, name, item)
  local stack = ItemStack(name)
  stack = mg_bolts.set_enchant_staff(stack, item.enchant1)
  inv:add_item('main', stack)
end

local function on_wand_spawn (item, pos)
  item.enchant1 = rand_range(2,5)

  core.set_node(pos, {name=chest})
  local loc = {type="node", pos=pos}
  local inv = core.get_inventory(loc)

  add_staff(inv, item.node_name, item)
  return item
end

local function randStaffEnchant()
  local enchant = 2
  if rand_percent(50) then
    enchant = enchant + 1
    if rand_percent(15) then
      enchant = enchant + 1
      if rand_percent(10) then
        enchant = enchant + 1
      end
    end
  end
  return enchant
end

local function on_staff_spawn (item, pos)
  item.enchant1 = randStaffEnchant()

  core.set_node(pos, {name=chest})
  local loc = {type="node", pos=pos}
  local inv = core.get_inventory(loc)

  add_staff(inv, item.node_name, item)
  return item
end

local function add_charm(inv, name, item)
  local stack = ItemStack(name)
  stack = mg_bolts.set_enchant_charm(stack, item.enchant1)
  inv:add_item('main', stack)
end


local function randCharmEnchant()
  local enchant = rand_range(1,2)
  while rand_percent(7) do
    enchant = enchant + 1
  end
  return enchant
end

local function on_charm_spawn (item, pos)
  item.enchant1 = randCharmEnchant()

  core.set_node(pos, {name=chest})
  local loc = {type="node", pos=pos}
  local inv = core.get_inventory(loc)

  add_charm(inv, item.node_name, item)
  return item
end




-- Categories for items
registerItemCategory('gold', {prob = 50, on_item_spawn=on_gold_spawn})
registerItemCategory('scroll', {prob = 32, on_item_spawn=on_consumable_spawn})
registerItemCategory('potion', {prob = 52, on_item_spawn=on_consumable_spawn})
registerItemCategory('food', {prob = 2, on_item_spawn=on_consumable_spawn})

registerItemCategory('amulet', {prob = 0, on_item_spawn=on_amulet_spawn})
registerItemCategory('gem', {prob = 0})
registerItemCategory('key', {prob = 0})

registerItemCategory('staff', {prob = 10, on_item_spawn=on_staff_spawn})
registerItemCategory('wand', {prob = 5, on_item_spawn=on_wand_spawn})
registerItemCategory('weapon', {prob = 10, on_item_spawn=on_weapon_spawn})
registerItemCategory('armor', {prob = 8, on_item_spawn=on_armor_spawn})
registerItemCategory('ring', {prob = 6, on_item_spawn=on_ring_spawn})
registerItemCategory('charm', {prob = 7, on_item_spawn=on_charm_spawn})

-- Food
registerMgItem("ration of food", "mg_mapgen:food_ration", "food", 3, 25, 1800, {0,0,0}, true, false, 0, false, "A ration of food")
registerMgItem("mango", "mg_mapgen:apple", "food", 1, 15, 1550, {0,0,0}, true, false, 0, false, "An odd fruit to be found so deep beneath the surface.")

-- Weapons
registerMgItem("dagger", "mg_tools:dagger",          "weapon", 10, 190, 12, { 3, 4,1}, true, false, 0, false, "A simple iron dagger.")
registerMgItem("short sword", "mg_tools:shortsword",          "weapon", 10, 440, 15, { 3, 5,1}, true, false, 0, false, "Thin and deft blade.")
registerMgItem("sword", "mg_tools:sword",           "weapon", 10, 440, 14, { 7, 9,1}, true, false, 0, false, "Steal sword")
registerMgItem("greatsword", "mg_tools:greatsword",      "weapon", 10, 990, 19, {14,22,1}, true, false, 0, false, "Towering blade")
registerMgItem("quarterstaff", "mg_tools:quarterstaff",            "weapon", 10, 440, 14, { 3, 5,1}, true, false, 0, false, "Get people 5 spaces away")
--registerMgItem("flail", "mg_tools:mace",           "weapon", 10, 440, 17, { 9,15,1}, true, false, 0, false, "Spiked iron ball")
registerMgItem("mace", "mg_tools:mace",            "weapon", 10, 660, 16, {16,20,1}, true, false, 0, false, "Extra turn, push back")
registerMgItem("war hammer", "mg_tools:warhammer",      "weapon", 10,1100, 20, {25,35,1}, true, false, 0, false, "Extra turn, push back")
registerMgItem("spear", "mg_tools:spear",           "weapon", 10, 330, 13, { 4, 5,1}, true, false, 0, false, "Slender wooden rod. Get enemy and one behind it.")
registerMgItem("war pike", "mg_tools:glaive",        "weapon", 10, 880, 18, {11,15,1}, true, false, 0, false, "Heavy spear")
registerMgItem("axe", "mg_tools:handaxe",             "weapon", 10, 550, 15, {7,9,1}, true, false, 0, false, "Heavy spear")
registerMgItem("battleaxe", "mg_tools:battleaxe",         "weapon", 10, 990, 19, {12,17,1}, true, false, 0, false, "Heavy spear")
registerMgItem("arrow", "bows:arrow",            "weapon", 10,  15, 10, { 2, 4,1}, true, false, 0, false, "Simple wooden arrows.")
registerMgItem("fire arrow", "bows:fire_arrow", "weapon", 10,  25, 12, { 1, 2,1}, true, false, 0, false, "Arrows that will catch their target on fire.")
registerMgItem("steel arrow", "bows:steel_arrow",         "weapon", 10,  40, 15, { 3,11,3}, true, false, 0, false, "Steel tiped arrows.")

-- Armor
registerMgItem("leather armor", "mg_armor:torso_cloth", "armor", 10,  250, 10, { 30, 30,0}, true, false, 0, false, "Lightweight armor")
registerMgItem("scale mail", "mg_armor:torso_leather",    "armor", 10,  350, 12, { 40, 40,0}, true, false, 0, false, "Bronze scales")
registerMgItem("chain mail", "mg_armor:torso_wood",    "armor", 10,  500, 13, { 50, 50,0}, true, false, 0, false, "Interlocking metal links")
registerMgItem("banded mail", "mg_armor:torso_mail",   "armor", 10,  800, 15, { 70, 70,0}, true, false, 0, false, "Overlapping strips")
registerMgItem("splint mail", "mg_armor:torso_scale",   "armor", 10, 1000, 17, { 90, 90,0}, true, false, 0, false, "Thick plates")
registerMgItem("plate armor", "mg_armor:torso_plate",   "armor", 10, 1300, 19, {110,110,0}, true, false, 0, false, "huge plates of metal")

-- Scrolls
registerMgItem("enchanting", "mg_scrolls:enchant",    "scroll",  0,  550, 0, {0,0,0}, false, false, 1, false, "Increase magical power of an item")
registerMgItem("identity", "mg_scrolls:identity",      "scroll", 20,  300, 0, {0,0,0}, false, false, 1, false, "Identity item")
registerMgItem("teleportation", "mg_scrolls:teleport", "scroll", 10,  500, 0, {0,0,0}, false, false, 1, false, "escape and instantly relocate")
-- registerMgItem("remove curse", "",  "scroll", 15,  150, 0, {0,0,0}, false, false, 1, false, "Take curse away")
registerMgItem("recharging", "mg_scrolls:recharging",    "scroll", 12,  375, 0, {0,0,0}, false, false, 1, false, "recarge all your staffs and charms")
registerMgItem("protect armor", "mg_scrolls:protect_armor", "scroll", 10,  400, 0, {0,0,0}, false, false, 1, false, "protect armor from acid")
registerMgItem("protect weapon", "mg_scrolls:protect_weapon","scroll", 10,  400, 0, {0,0,0}, false, false, 1, false, "protect weapon from acid")
-- registerMgItem("sanctuary", "",     "scroll", 10,  500, 0, {0,0,0}, false, false, 1, false, "Imbue ground around you with glyph that monsters won't cross")
-- registerMgItem("magic mapping", "", "scroll", 12,  500, 0, {0,0,0}, false, false, 1, false, "Reveal traps, secret doors and hidden levers.")
-- registerMgItem("negation", "",      "scroll",  8,  400, 0, {0,0,0}, false, false, 1, false, "Stripe everything of magic")
registerMgItem("shattering", "mg_scrolls:shattering",    "scroll",  8,  500, 0, {0,0,0}, false, false, 1, false, "Cause stone to evaporate")
-- registerMgItem("discord", "",       "scroll",  8,  400, 0, {0,0,0}, false, false, 1, false, "Monsters will turn against themselves for 45 seconds")
-- registerMgItem("aggravate monsters", "","scroll",15,50, 0, {0,0,0}, false, false,-1, false, "Wake up all monsters and they'll hunt you!")
-- registerMgItem("summon monsters", "","scroll",10,   50, 0, {0,0,0}, false, false,-1, false, "Spawn random monsters in front of you")

-- Potions
registerMgItem("life", "mg_potions:life",          "potion",  0,  500, 0, {0,0,0}, false, false, 1, false, "Instantly heal and cure you.")
registerMgItem("strength", "mg_potions:strength",      "potion",  0,  400, 0, {0,0,0}, false, false, 1, false, "Increase strength value by 1.")

registerMgItem("levitation", "pep:grav0",    "potion", 15,  250, 0, {0,0,0}, false, false, 1, false, "Hover")
registerMgItem("speed", "pep:speedplus",         "potion", 10,  500, 0, {0,0,0}, false, false, 1, false, "Go fast")
registerMgItem("fire immunity", "pep:fire_immunity", "potion", 15,  500, 0, {0,0,0}, false, false, 1, false, "Fire can't touch this")
registerMgItem("invisibility", "pep:invisibility",  "potion", 15,  400, 0, {0,0,0}, false, false, 1, false, "Enemies more than two spaces away can't track you.")
-- registerMgItem("telepathy", "",     "potion", 20,  350, 0, {0,0,0}, false, false, 1, false, "Sense where monsters are.")
-- registerMgItem("detect magic", "",  "potion", 20,  500, 0, {0,0,0}, false, false, 1, false, "Good bad items")

registerMgItem("caustic gas", "mg_potions:caustic_gas",   "potion", 15,  200, 0, {0,0,0}, false, false,-1, false, "Bad gas, don't drink, throw at bad guys.")
registerMgItem("incineration", "mg_potions:incineration",  "potion", 15,  500, 0, {0,0,0}, false, false,-1, false, "Loads of fire.  Also makes steam in lakes or chasms.")
registerMgItem("descent", "mg_potions:descent",       "potion", 15,  500, 0, {0,0,0}, false, false,-1, false, "Ground goes bye bye for a little bit")
registerMgItem("creeping death", "mg_potions:deadly_lichen","potion",  7,  450, 0, {0,0,0}, false, false,-1, false, "Deadly lichen grows. Burn to remove.")
-- registerMgItem("confusion", "",     "potion", 15,  450, 0, {0,0,0}, false, false,-1, false, "loose control")
-- registerMgItem("darkness", "",      "potion",  7,  150, 0, {0,0,0}, false, false,-1, false, "I'm blind!")
-- registerMgItem("paralysis", "",     "potion", 10,  250, 0, {0,0,0}, false, false,-1, false, "Stuck!")

-- Wands
registerMgItem("teleportation", "mg_bolts:wand_teleportation",  "wand",    3, 800, 1, {3,5,1}, false, false, 1, false, "Teleport a creature to random place.")
registerMgItem("polymorph", "mg_bolts:wand_polymorph",      "wand",    3, 800, 1, {3,5,1}, false, false, 1, false, "Turn a creature into another type of creature")

-- Staves
registerMgItem("lightning", "mg_bolts:lightning_staff",  "staff",    15, 1300, 1, {2,4,1}, false, false, 1, false, "Arcs of electrcity")
registerMgItem("firebolt", "mg_bolts:fire_staff",   "staff",    15, 1300, 2, {2,4,1}, false, false, 1, false, "Ignites flammable terrain and burn creatures.")
registerMgItem("poison", "mg_bolts:poison_staff",     "staff",    10, 1200, 3, {2,4,1}, false, false, 1, false, "Imbue target with deadly venom")
registerMgItem("tunneling", "mg_bolts:tunneling_staff",  "staff",    10, 1000, 4, {2,4,1}, false, false, 1, false, "Reduce obstructions to rubble")
registerMgItem("blinking", "mg_bolts:blinking_staff",   "staff",    11, 1200, 5, {2,4,1}, false, false, 1, false, "Teleport in a direction.  ")
registerMgItem("obstruction", "mg_bolts:obstruction_staff",   "staff", 11, 1200, 5, {2,4,1}, false, false, 1, false, "Entomb your enemies")
registerMgItem("protection", "mg_bolts:protection_staff",    "staff", 11, 1200, 5, {2,4,1}, false, false, 1, false, "Protection")
--TODO conjuring

-- Rings
registerMgItem("stealth", "mg_rings:ring_stealth3",       "ring",  1, 800, 1, {1,3,1}, false, false, 1, false, "Hard for enemies to track you")
registerMgItem("regeneration", "mg_rings:ring_regeneration2",  "ring",  1, 750, 1, {1,3,1}, false, false, 1, false, "Heal faster")
registerMgItem("transference", "mg_rings:ring_transference1",  "ring",  1, 750, 1, {1,3,1}, false, false, 1, false, "This ring of blood magic will heal you in proportion to the damage you inflict on others. Cursed rings will cause you to lose health when inflicting damage.")
registerMgItem("reaping", "mg_rings:ring_reaping3",       "ring",  1, 700, 1, {1,3,1}, false, false, 1, false, "Every you hit you land has a good chance to speed up recharing")
registerMgItem("wisdom", "mg_rings:ring_wisdom1",        "ring",  1, 700, 1, {1,3,1}, false, false, 1, false, "Reduces total time for staffs to recharge.")

-- Charms
registerMgItem("health", "mg_bolts:health_charm",       "charm",      5, 900, 0, {1,2,1}, false, false, 1, false, "Health charm")
registerMgItem("haste", "mg_bolts:haste_charm",       "charm",       5, 750, 0, {1,2,1}, false, false, 1, false, "Haste charm")
registerMgItem("fire immunity", "mg_bolts:fire_immunity_charm", "charm",     5, 750, 0, {1,2,1}, false, false, 1, false, "Fire Immunity")
registerMgItem("levitation", "mg_bolts:levitation_charm",       "charm",  5, 700, 0, {1,2,1}, false, false, 1, false, "Levitation charm")
registerMgItem("shattering", "mg_bolts:shattering_charm",       "charm",  5, 700, 0, {1,2,1}, false, false, 1, false, "Shattering charm")
registerMgItem("recharging", "mg_bolts:recharging_charm",       "charm",  5, 700, 0, {1,2,1}, false, false, 1, false, "Recharging charm")
registerMgItem("teleportation", "mg_bolts:teleportation_charm",    "charm",  5, 700, 0, {1,2,1}, false, false, 1, false, "Teleport charm")
registerMgItem("invisibility", "mg_bolts:invisibility_charm",     "charm",  5, 700, 0, {1,2,1}, false, false, 1, false, "Invisibility Charm")
registerMgItem("protection", "mg_bolts:protection_charm",     "charm",    5, 800, 0, {1,2,1}, false, false, 1, false, "Protection")
--registerMgItem("guardian",   "",    5, 800, 0, {1,2,1}, false, false, 1, false, "Charm2")

