local collisionbox = {-0.25, -.01*1.3, -0.25, 0.25, .9*1.6, 0.25}

minetest.register_entity("mg_mobs:goblin",{
  physical = true,
  stepheight = 0.1,				--EVIL!
  visual = "mesh",
  mesh = "goblins_goblin.b3d",
  textures = {
    "goblins_goblin_cobble1.png",
    "voxeldungeon_tool_weapon_mace.png"
  },
  collide_with_objects = true,
  collisionbox = collisionbox,
  visual_size = {x=1.6, y=1.6},
  static_save = true,
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.9,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10,			-- seconds
  max_hp = 15,
  regen = 20,
  defense = 10,
  accuracy = 70,
  attack={range=1.5,damage_groups={fleshy=2, fleshy_max=5}},
  sounds = {
    random = "goblins_goblin_breathing",
    warn = "goblins_goblin_attack",
    attack = "goblins_goblin_attack",
    hurt = "goblins_goblin_damage",
    death = "goblins_goblin_death",
    replace = "goblins_goblin_pick",
  },
  animation = {
    stand={range={x=0,y=79},speed=30,loop=true},
    walk={range={x=168,y=187},speed=30,loop=true},
    run={range={x=168,y=187},speed=60,loop=true},
    punch={range={x=200,y=219},speed=60,loop=true},
  },

  behaviors = { },
  abilities = {
    -- attack range is two squares
    -- and can go through one enemy
    -- to another
    attacks_penetrate = 1,
    avoid_corridors = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:goblin", "Goblin", 1);

minetest.register_entity("mg_mobs:goblin_conjurer",{
  physical = true,
  stepheight = 0.1,				--EVIL!
  visual = "mesh",
  mesh = "goblins_goblin.b3d",
  textures = {"goblins_goblin_fungler1.png"},
  collide_with_objects = true,
  collisionbox = collisionbox,
  visual_size = {x=1.6, y=1.6},
  static_save = true,
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.9,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10,			-- seconds
  max_hp = 10,
  regen = 20,
  defense = 10,
  accuracy = 70,
  attack={range=0.75,damage_groups={fleshy=2, fleshy_max=4}},
  sounds = {
    random = "goblins_goblin_breathing",
    warn = "goblins_goblin_attack",
    attack = "goblins_goblin_attack",
    hurt = "goblins_goblin_damage",
    death = "goblins_goblin_death",
    replace = "goblins_goblin_pick",
  },
  animation = {
    stand={range={x=0,y=79},speed=30,loop=true},
    walk={range={x=168,y=187},speed=30,loop=true},
    run={range={x=168,y=187},speed=60,loop=true},
    punch={range={x=200,y=219},speed=60,loop=true},
  },

  behaviors = {
    maintains_distance = 1,
    cast_spells_slowly = 1,
    carry_item_25 = 1,
  },
  abilities = {
    cast_summon = 1,
    avoids_corridors = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:goblin_conjurer", "Goblin Conjurer", 1);

minetest.register_entity("mg_mobs:goblin_mystic",{
  physical = true,
  stepheight = 0.1,				--EVIL!
  visual = "mesh",
  mesh = "goblins_goblin.b3d",
  textures = {"goblins_goblin_gold2.png"},
  collide_with_objects = true,
  collisionbox = collisionbox,
  visual_size = {x=1.6, y=1.6},
  static_save = true,
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.9,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10,			-- seconds
  max_hp = 10,
  regen = 20,
  defense = 10,
  accuracy = 70,
  attack={range=0.75,damage_groups={fleshy=2, fleshy_max=4}},
  sounds = {
    random = "goblins_goblin_breathing",
    warn = "goblins_goblin_attack",
    attack = "goblins_goblin_attack",
    hurt = "goblins_goblin_damage",
    death = "goblins_goblin_death",
    replace = "goblins_goblin_pick",
  },
  animation = {
    stand={range={x=0,y=79},speed=30,loop=true},
    walk={range={x=168,y=187},speed=30,loop=true},
    run={range={x=168,y=187},speed=60,loop=true},
    punch={range={x=200,y=219},speed=60,loop=true},
  },

  bolts = {
    'protection'
  },
  behaviors = {
    maintains_distance = 1,
    carry_item_25 = 1,
  },
  abilities = {
    avoids_corridors = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:goblin_mystic", "Goblin Mystic", 1);
