minetest.register_node("mg_torch:torch", {
	description = "Torch",
	drawtype = "mesh",
	mesh = "mg_torch_floor.obj",
	inventory_image = "mg_torch_on_floor.png",
	wield_image = "mg_torch_on_floor.png",
	tiles = {{
		    name = "mg_torch_on_floor_animated.png",
		    animation = {type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 3.3}
	}},
	use_texture_alpha = "clip",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	pointable = false,
	liquids_pointable = false,
	light_source = 12,
	groups = {choppy=2, dig_immediate=3, attached_node=1, torch=1},
	drop = "mg_torch:torch",
	selection_box = {
		type = "wallmounted",
		wall_bottom = {-1/8, -1/2, -1/8, 1/8, 2/16, 1/8},
	},
	sounds = mg_media.node_sound_wood_defaults(),
	on_place = function(itemstack, placer, pointed_thing)
		local under = pointed_thing.under
		local node = minetest.get_node(under)
		local def = minetest.registered_nodes[node.name]
		if def and def.on_rightclick and
			not (placer and placer:is_player() and
			placer:get_player_control().sneak) then
			return def.on_rightclick(under, node, placer, itemstack,
				pointed_thing) or itemstack
		end

		local above = pointed_thing.above
		local wdir = minetest.dir_to_wallmounted(vector.subtract(under, above))
		local fakestack = itemstack
		if wdir == 0 then
			fakestack:set_name("mg_torch:torch_ceiling")
		elseif wdir == 1 then
			fakestack:set_name("mg_torch:torch")
		else
			fakestack:set_name("mg_torch:torch_wall")
		end

		itemstack = minetest.item_place(fakestack, placer, pointed_thing, wdir)
		itemstack:set_name("mg_torch:torch")

		return itemstack
	end,
	floodable = true,
	on_rotate = false
})

minetest.register_node("mg_torch:torch_wall", {
	drawtype = "mesh",
	mesh = "mg_torch_wall.obj",
	tiles = {{
		    name = "mg_torch_on_floor_animated.png",
		    animation = {type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 3.3}
	}},
	use_texture_alpha = "clip",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	pointable = false,
	light_source = 12,
	groups = {choppy=2, dig_immediate=3, not_in_creative_inventory=1, attached_node=1, torch=1},
	drop = "mg_torch:torch",
	selection_box = {
		type = "wallmounted",
		wall_side = {-1/2, -1/2, -1/8, -1/8, 1/8, 1/8},
	},
	sounds = mg_media.node_sound_wood_defaults(),
	floodable = true,
	on_rotate = false
})

for i=1,12 do
  minetest.register_node("mg_torch:torch_wall"..i, {
    drawtype = "mesh",
    mesh = "mg_torch_wall.obj",
    tiles = {{
          name = "mg_torch_on_floor_animated.png",
          animation = {type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 3.3}
    }},
    use_texture_alpha = "clip",
    paramtype = "light",
    paramtype2 = "wallmounted",
    sunlight_propagates = true,
    walkable = false,
    pointable = false,
    light_source = i,
    groups = {choppy=2, dig_immediate=3, not_in_creative_inventory=1, attached_node=1, torch=1},
    drop = "mg_torch:torch",
    selection_box = {
      type = "wallmounted",
      wall_side = {-1/2, -1/2, -1/8, -1/8, 1/8, 1/8},
    },
    sounds = mg_media.node_sound_wood_defaults(),
    floodable = true,
    on_rotate = false
  })
end

minetest.register_node("mg_torch:torch_ceiling", {
	drawtype = "mesh",
	mesh = "mg_torch_ceiling.obj",
	tiles = {{
		    name = "mg_torch_on_floor_animated.png",
		    animation = {type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 3.3}
	}},
	use_texture_alpha = "clip",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	light_source = 12,
	groups = {choppy=2, dig_immediate=3, not_in_creative_inventory=1, attached_node=1, torch=1},
	drop = "mg_torch:torch",
	selection_box = {
		type = "wallmounted",
		wall_top = {-1/8, -1/16, -5/16, 1/8, 1/2, 1/8},
	},
	sounds = mg_media.node_sound_wood_defaults(),
	floodable = true,
	on_rotate = false
})

minetest.register_lbm({
	name = "mg_torch:3dtorch",
	nodenames = {"mg_torch:torch", "mg_torch:torch_floor", "mg_torch:torch_wall"},
	action = function(pos, node)
		if node.param2 == 0 then
			minetest.set_node(pos, {name = "mg_torch:torch_ceiling",
				param2 = node.param2})
		elseif node.param2 == 1 then
			minetest.set_node(pos, {name = "mg_torch:torch",
				param2 = node.param2})
		else
			minetest.set_node(pos, {name = "mg_torch:torch_wall",
				param2 = node.param2})
		end
	end
})

minetest.register_craft({
	output = "mg_torch:torch 4",
	recipe = {
		{"mg_mapgen:leaves"},
		{"mg_mapgen:wood"}
	}
})


for i=1,14 do
  core.register_node("mg_torch:air_light_"..i, {
    description = "Air light level " .. i,
    drawtype = "airlike",
    paramtype = "light",
    sunlight_propagates = true,
    light_source = i,
    walkable = false,
    pointable = false,
    diggable = false,
    buildable_to = true,
    air_equivalent = true,
    floodable = true,
    drop = "",
    groups = {air=1}
  })
end


minetest.register_node("mg_torch:light", {
	description = "Light",
	tiles = {"light_light.png"},
	paramtype = "light",
	light_source = 14,
	is_ground_content = false,
	groups = {carcky = 3},
})
