mg_bolts = {
  registered_bolts = {}
}

mg_bolts.register_bolt = function(name, def)

	if name == nil or name == "" then
		return false
	end

	def.damage = def.damage or 0
	def.name = "mg_bolts:" .. name
	def.level = def.level or 1
	def.on_hit_object = def.on_hit_object
	def.on_hit_node = def.on_hit_node
	def.on_hit_sound = def.on_hit_sound or "default_dig_dig_immediate"

	mg_bolts.registered_bolts[def.name] = def

  -- shouldnt be holding a bolt...
	minetest.register_craftitem(":mg_bolts:" .. name, {
    range = 1.5,
		description = def.description or name,
		inventory_image = def.texture or "mg_bolts_light.png",
		groups = {arrow = 1},
		drop_chance = def.drop_chance
	})

	if def.craft then

		minetest.register_craft({
			output = def.name .." " .. (def.craft_count or 4),
			recipe = def.craft
		})
	end
end

local on_remove = function(self, user, lastpos)
	if mg_bolts.registered_bolts[self.name].on_remove then
		mg_bolts.registered_bolts[self.name].on_remove(self,  user, lastpos)
	end
	return self
end


local on_hit_remove = function(self)

	minetest.sound_play(
		mg_bolts.registered_bolts[self.name].on_hit_sound, {
			pos = self.object:get_pos(),
			gain = 1.0,
			max_hear_distance = 12
		}, true)

	self.object:remove()
	return self
end

-- Easy way to fix lightning for now is eas bolt can only damage
-- the target once

local function get_target_id(target)
  if target:is_player() then
    return target:get_player_name()
  end

  -- not sure how to handle other entities...
  local mob = target:get_luaentity()

  local id = mob.mg_id
  -- should be an id, but if not set one
  -- either spawned by an egg or its not a mobkit entity
  if not id then
    id = mg_mobs.uuid()
    mob.mg_id = id
  end

  return id
end

local function clear_hit_list(self)
  self.mg_hit_list = nil
end

local function check_has_hit_before(self, target)
  local target_id = get_target_id(target)
  if not target_id then
    return false
  end
  local hits = self.mg_hit_list

  -- hasn't hit any objects before
  -- add target to hit list
  if not hits then
    self.mg_hit_list = {target_id}
    return false
  end

  for _, hit_id in ipairs(hits) do
    if hit_id == target_id then
      return true
    end
  end

  -- if we get here we haven't seen this entity
  -- before add to list return false
  table.insert(self.mg_hit_list, target_id)
  return false
end

local function clamp(x, low, high)
  return math.min(high, math.max(x, low))
end

local function rand_percent(percent)
  return math.random(0,99) < clamp(percent, 0, 100)
end

local on_hit_object = function(self, target, hp, user, lastpos)
  local has_hit_before = false

  if not self.stop_on_object or self.stop_on_object == 0 then
    -- only check if we don't stop on an object
    has_hit_before = check_has_hit_before(self, target)
  end

  if has_hit_before then
    return
  end

  -- if the mob it hits has reflection, then find a random target and shoot the bolt at that target
  -- and don't punch player
  -- 48% chance to refeclt the bot in a random direction
  -- 48% to reflect back to player
  -- TODO - runic for armor of relfection for player
  local mob = target:get_luaentity()
  if mob and mob.behaviors and
     mob.behaviors.reflective and
     rand_percent(48)
  then
    clear_hit_list(self)
    -- reverse the velocity
    local vel = self.object:get_velocity()
    self.object:set_velocity(vector.multiply(vel, -1))
    -- reset the timer
    self.timer = self.duration
    if rand_percent(48) then
      -- delete this bolt and shoot a new bolt from the mob
      local target_pos = mobkit.get_middle_pos(user)
      mg_bolts.mob_shoot(self.arrow, mob.object, target_pos, self.duration, self.enchant)
      self.object:remove()
      return self
    else
      return self
    end
  end

  if hp and hp > 0 then
    target:punch(user, 0.1, {
      full_punch_interval = 0.1,
      damage_groups = {fleshy = hp},
    }, nil)
  end

	if mg_bolts.registered_bolts[self.name].on_hit_object then
		mg_bolts.registered_bolts[self.name].on_hit_object(
			self, target, hp, user, lastpos)
	end

  if(self.stop_on_object > 0) then
    on_remove(self, user, lastpos)
    on_hit_remove(self)
  end

	return self
end


minetest.register_entity("mg_bolts:bolt",{

	initial_properties = {
		hp_max = 10,
		visual = "wielditem",
		visual_size = {x = .20, y = .20},
		collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
		physical = false,
		textures = {"air"}
	},

	_is_arrow = true,
	timer = 10,

	on_activate = function(self, _staticdata)

		if not self then
			self.object:remove()
			return
		end

		if mg_bolts.tmp and mg_bolts.tmp.arrow ~= nil then

			self.bolt = mg_bolts.tmp.bolt
			self.arrow = mg_bolts.tmp.arrow
			self.user = mg_bolts.tmp.user
			self.name = mg_bolts.tmp.name
			self.timer = mg_bolts.tmp.timer
			self.enchant = mg_bolts.tmp.enchant or 1
			self.dmg = mg_bolts.registered_bolts[self.name].damage
			self.reflection = mg_bolts.registered_bolts[self.name].reflection or 0
			self.stop_on_object = mg_bolts.registered_bolts[self.name].stop_on_object or 0
			self.stop_on_node = mg_bolts.registered_bolts[self.name].stop_on_node or 0

			mg_bolts.tmp = nil

			self.object:set_properties({textures = {self.arrow}})
		else
			self.object:remove()
		end
	end,

	on_step = function(self, dtime)

		self.timer = self.timer - dtime

		local pos = self.object:get_pos()
    self.oldpos = self.oldpos or pos

		if self.timer < 0 then
      on_remove(self, self.user, self.oldpos)
      if mg_bolts.registered_bolts[self.name].on_timeout then
        mg_bolts.registered_bolts[self.name].on_timeout(self, pos, self.user, self.oldpos)
      end
			self.object:remove()
			return
		end

		local cast = minetest.raycast(self.oldpos, pos, true, true)
		local thing = cast:next()
		local ok = true

    if mg_bolts.registered_bolts[self.name].on_step then
      mg_bolts.registered_bolts[self.name].on_step(
          self, pos, self.user, self.oldpos)
    end

		-- loop through things
		while thing do

			-- ignore the object that is the arrow
			if thing.type == "object" and thing.ref ~= self.object then

				-- add entity name to thing table (if not player)
				if not thing.ref:is_player() then
					thing.name = thing.ref:get_luaentity() and thing.ref:get_luaentity().name
				end

				-- check if dropped item or yourself
				if thing.name == "__builtin:item"
          or (not thing.name and
              thing.ref == self.user)
        then
					ok = false
				end

				-- can we hit entity ?
				if ok then
          local dmg = self.dmg
          local calc_damage = mg_bolts.registered_bolts[self.name].calc_damage
          if(calc_damage) then
            dmg = calc_damage(self.enchant)
          end
					on_hit_object(self, thing.ref, dmg, self.user, {x = pos.x, y = pos.y, z = pos.z})
					return self
				end

			-- are we inside a node ?
			elseif thing.type == "node" then
				self.node = minetest.get_node(pos)
				local def = minetest.registered_nodes[self.node.name]

				if def and def.walkable then
					if mg_bolts.registered_bolts[self.name].on_hit_node then
						mg_bolts.registered_bolts[self.name].on_hit_node(self, pos, self.user, self.oldpos)
					end

          if(self.stop_on_node > 0) then
            on_remove(self, self.user, self.oldpos)
            on_hit_remove(self)
            return self
          end

          if(self.reflection > 0) then
            -- clear the hit list so previously hit
            -- objects can be hit again
            clear_hit_list(self)
            -- reverse the velocity
            local vel = self.object:get_velocity()
            self.object:set_velocity(vector.multiply(vel, -1))
          end

				end
			end

			thing = cast:next()
		end

		self.oldpos = pos
	end
})

mg_bolts.mob_shoot = function (bolt, mob, target_pos, duration, enchant)
  duration = duration or 1
  local level = 10

  -- This is weird to me
  -- why not just modify the lua entity object instead?
  mg_bolts.tmp = {}
  mg_bolts.tmp.arrow = bolt
  mg_bolts.tmp.user = mob
  mg_bolts.tmp.name = bolt
  mg_bolts.tmp.timer = duration
  mg_bolts.tmp.enchant = enchant or 1

  local pos = mobkit.get_middle_pos(mob)
  local dir = vector.direction(pos, target_pos)

  local e = core.add_entity({
    x = pos.x + dir.x*0.5,
    y = pos.y + dir.y*0.5,
    z = pos.z + dir.z*0.5
  }, "mg_bolts:bolt")


  e:set_velocity({x = dir.x * level, y = dir.y * level, z = dir.z * level})
  e:set_acceleration({x = 0, y = 0, z = 0})

  local yaw = core.dir_to_yaw(dir)
  e:set_yaw(yaw)

  core.sound_play("mg_zap", {pos = pos, max_hear_distance = 10}, true)
end


mg_bolts.shoot = function (arrow, user, duration, enchant)
  -- eye height, pos, dir
  duration = duration or 1
  local level = 10

  -- This is weird to me
  -- why not just modify the lua object instead?
  mg_bolts.tmp = {}
  mg_bolts.tmp.arrow = arrow
  mg_bolts.tmp.user = user
  mg_bolts.tmp.name = arrow
  mg_bolts.tmp.timer = duration
  mg_bolts.tmp.enchant = enchant or 1

  local prop = user:get_properties()
  local pos = user:get_pos()

  pos.y = pos.y + (prop.eye_height or 1.23)

  local dir = user:get_look_dir()

  local e = minetest.add_entity({ x = pos.x, y = pos.y, z = pos.z }, "mg_bolts:bolt")

  e:set_velocity({x = dir.x * level, y = dir.y * level, z = dir.z * level})
  e:set_acceleration({x = 0, y = 0, z = 0})
  e:set_yaw(user:get_look_horizontal())

  minetest.sound_play("mg_zap", {pos = pos, max_hear_distance = 10}, true)
end
