mg_chest = {}
mg_chest.chest = {}

-- support for MT game translation.
local function S(s)
  return s
end

function get_hotbar_bg(x,y)
	local out = ""
	for i=0,7,1 do
		out = out .."image["..x+i..","..y..";1,1;gui_hb_bg.png]"
	end
	return out
end

function mg_chest.chest.get_chest_formspec(pos)
	local spos = pos.x .. "," .. pos.y .. "," .. pos.z
	local formspec =
		"size[8,9]" ..
		"list[nodemeta:" .. spos .. ";main;0,0.3;8,4;]" ..
		"list[current_player;main;0,4.85;8,1;]" ..
		"list[current_player;main;0,6.08;8,3;8]" ..
		"listring[nodemeta:" .. spos .. ";main]" ..
		"listring[current_player;main]" ..
		get_hotbar_bg(0,4.85)
	return formspec
end

function mg_chest.chest.chest_lid_obstructed(pos)
	local above = {x = pos.x, y = pos.y + 1, z = pos.z}
	local def = minetest.registered_nodes[minetest.get_node(above).name]
	-- allow ladders, signs, wallmounted things and torches to not obstruct
	if def and
			(def.drawtype == "airlike" or
			def.drawtype == "signlike" or
			def.drawtype == "torchlike" or
			(def.drawtype == "nodebox" and def.paramtype2 == "wallmounted")) then
		return false
	end
	return true
end

function mg_chest.chest.chest_lid_close(pn)
	local chest_open_info = mg_chest.chest.open_chests[pn]
	local pos = chest_open_info.pos
	local sound = chest_open_info.sound
	local swap = chest_open_info.swap

	mg_chest.chest.open_chests[pn] = nil
	for k, v in pairs(mg_chest.chest.open_chests) do
		if v.pos.x == pos.x and v.pos.y == pos.y and v.pos.z == pos.z then
			return true
		end
	end

  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()

  if not inv:is_empty("main") then
    local node = minetest.get_node(pos)
    -- only close if there's something in the inventory
    minetest.after(0.2, minetest.swap_node, pos, { name = swap,
        param2 = node.param2 })
    minetest.sound_play(sound, {gain = 0.3, pos = pos,
      max_hear_distance = 10}, true)
  end
end

mg_chest.chest.open_chests = {}

minetest.register_on_player_receive_fields(function(player, formname, fields)
	local pn = player:get_player_name()

	if formname ~= "mg_chest:chest" then
		if mg_chest.chest.open_chests[pn] then
			mg_chest.chest.chest_lid_close(pn)
		end

		return
	end

	if not (fields.quit and mg_chest.chest.open_chests[pn]) then
		return
	end

	mg_chest.chest.chest_lid_close(pn)

	return true
end)

minetest.register_on_leaveplayer(function(player)
	local pn = player:get_player_name()
	if mg_chest.chest.open_chests[pn] then
		mg_chest.chest.chest_lid_close(pn)
	end
end)

function mg_chest.chest.register_chest(prefixed_name, d)
	local name = prefixed_name:sub(1,1) == ':' and prefixed_name:sub(2,-1) or prefixed_name
	local def = table.copy(d)
	def.drawtype = "mesh"
	def.visual = "mesh"
	def.paramtype = "light"
	def.paramtype2 = "facedir"
	def.legacy_facedir_simple = true
	def.is_ground_content = false

  def.on_construct = function(pos)
    local meta = minetest.get_meta(pos)
    meta:set_string("infotext", S("Chest"))
    local inv = meta:get_inventory()
    inv:set_size("main", 8*2)
  end
  def.can_dig = function(pos, _player)
    local meta = core.get_meta(pos)
    local inv = meta:get_inventory()
    return inv:is_empty("main")
  end
  def.on_burn = function(burn_pos)
    local meta = core.get_meta(burn_pos)
    local inv = meta:get_inventory()
    local main_list = inv:get_list("main")

    if main_list then
      for idx, stack in ipairs(main_list) do
        core.item_drop(stack, nil, burn_pos)
        inv:set_stack("main", idx, nil)
      end
    end
    core.remove_node(burn_pos)
  end
  def.on_rightclick = function(pos, node, clicker)
    local cn = clicker:get_player_name()

    if mg_chest.chest.open_chests[cn] then
      mg_chest.chest.chest_lid_close(cn)
    end

    minetest.sound_play(def.sound_open, {gain = 0.3, pos = pos,
        max_hear_distance = 10}, true)
    if not mg_chest.chest.chest_lid_obstructed(pos) then
      minetest.swap_node(pos, {
          name = name .. "_open",
          param2 = node.param2 })
    end
    minetest.after(0.2, minetest.show_formspec,
        cn,
        "mg_chest:chest", mg_chest.chest.get_chest_formspec(pos))
    mg_chest.chest.open_chests[cn] = { pos = pos,
        sound = def.sound_close, swap = name }
	end

	--default.set_inventory_action_loggers(def, "chest")

	local def_opened = table.copy(def)
	local def_closed = table.copy(def)

	def_opened.mesh = "chest_open.obj"
	for i = 1, #def_opened.tiles do
		if type(def_opened.tiles[i]) == "string" then
			def_opened.tiles[i] = {name = def_opened.tiles[i], backface_culling = true}
		elseif def_opened.tiles[i].backface_culling == nil then
			def_opened.tiles[i].backface_culling = true
		end
	end
	def_opened.drop = name
	def_opened.groups.not_in_creative_inventory = 1
	def_opened.selection_box = {
		type = "fixed",
		fixed = { -1/2, -1/2, -1/2, 1/2, 3/16, 1/2 },
	}
	def_opened.can_dig = function()
		return false
	end
	def_opened.on_blast = function() end

	def_closed.mesh = nil
	def_closed.drawtype = nil
	def_closed.tiles[6] = def.tiles[5] -- swap textures around for "normal"
	def_closed.tiles[5] = def.tiles[3] -- drawtype to make them match the mesh
	def_closed.tiles[3] = def.tiles[3].."^[transformFX"

	minetest.register_node(prefixed_name, def_closed)
	minetest.register_node(prefixed_name .. "_open", def_opened)

	-- close opened chests on load
	--minetest.register_lbm({
		--label = "close opened chests on load",
		--name = "mg_chest:close_" .. prefixed_name:gsub(":", "_") .. "_open",
		--nodenames = {prefixed_name .. "_open"},
		--run_at_every_load = true,
		--action = function(pos, node)
			--node.name = prefixed_name
			--minetest.swap_node(pos, node)
		--end
	--})
end

mg_chest.chest.register_chest("mg_chest:chest", {
	description = S("Chest"),
	tiles = {
		"default_chest_top.png",
		"default_chest_top.png",
		"default_chest_side.png",
		"default_chest_side.png",
		"default_chest_front.png",
		"default_chest_inside.png"
	},
	sounds = mg_media.node_sound_wood_defaults(),
	sound_open = "default_chest_open",
	sound_close = "default_chest_close",
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 1},
	drop = "",
})

