

local function getPlayerAccuracy(player, tool_capabilities, time_from_last_punch)
    local str_required = tool_capabilities.damage_groups.strength_required or 12
    local enchant = tool_capabilities.damage_groups.enchant or 0
    local time_frac = time_from_last_punch / tool_capabilities.full_punch_interval
    if time_frac > 1 then
      time_frac = 1
    end

    local player_str = mg_strength.get_strength_raw(player) or 12
    local player_weakness = mg_strength.get_weakness(player) or 0

    local accuracy = mg_strength.damageFraction(mg_strength.netEnchant(
      enchant,
      str_required,
      player_str,
      player_weakness
    ))
    return 100 * accuracy * time_frac
end

local function getHitterAccuracy(hitter, tool_capabilities, time_from_last_punch)
  if hitter:is_player() then
    return getPlayerAccuracy(hitter, tool_capabilities, time_from_last_punch)
  end

  local mob = hitter:get_luaentity()
  if not mob then
    return 100
  end

  return mob.accuracy or 100
end

-- When a mob hits a player
core.register_on_punchplayer(function(player, hitter, time_from_last_punch, tool_capabilities, _dir, _damage)
  -- Fire, falling, and drowning do a direct HP change - it shouldn't go through here
  -- TODO if an acid mound hit a player, then the armor should degrad when I do enchanments
  -- Also if you hit an acid it should degrade your weapon
	local playername = player:get_player_name()

	if not playername then
    return true
  end

  print('player ' .. playername .. ' is punched')

  -- Should support hitter being a mob
  local player_str = mg_strength.get_strength_raw(hitter)
  local player_weakness = mg_strength.get_weakness(hitter)
  local dmg_min = tool_capabilities.damage_groups.fleshy or 0.5
  local dmg_max = tool_capabilities.damage_groups.fleshy_max or dmg_min
  -- for things like arrows or something else i forgot to set
  local str_required = tool_capabilities.damage_groups.strength_required or 12
  local enchant = tool_capabilities.damage_groups.enchant or 0
  local damage = mg_strength.calcDamage(
    enchant,
    str_required,
    dmg_min,
    dmg_max,
    player_str or 12,
    player_weakness or 0
  )

  -- Armor determines if a hit lands
  -- weapon determins how much damage how much it'll do
  local defense_fraction = mg_armor.get_player_defense_fraction(player)

  -- TODO certain monsters have better accuracy than others
  --      add this in later
  local hitter_accuracy = getHitterAccuracy(hitter, tool_capabilities, time_from_last_punch)

  print('hitter accuracy: ' .. hitter_accuracy)
  print('defense fraction: ' .. defense_fraction * 100)

  local hitProb = math.floor(hitter_accuracy * defense_fraction)

  print('hit prob: ' .. hitProb)

  local hit = mg_arch.rand_percent(hitProb)

  if mg_oe.has_effect("gas_paralysis", player) then
    mg_oe.clear_effect("gas_paralysis", player)
    hit = true
    if tool_capabilities.damage_groups.sneak_attack_bonus then
      damage = damage * 5
    else
      damage = damage * 3
    end
    print('player ' .. playername .. ' is paralyzed ' .. ' give an attack bonus, damage is now ' .. damage)
  end

  local hp = player:get_hp()
  if hit and hp > 0 then

    damage = mg_oe.apply_protection(player, damage)

    if damage == 0 then
      print('no damage because protected')
      local pos = hitter:get_pos()
      minetest.sound_play("protection", {
        pos = pos,
        gain = 1.0,
        max_hear_distance = 5,
      })
    end

    print('hit landed - damage player and apply hitter effects')
    mg_mobs.apply_hitter_abilities(player, hitter, damage)

    -- if hitter is another player, apply transference and reaping if applicate
    -- these do is player checks and won't do anything for mobs
    mg_rings.apply_player_transference(hitter, damage)
    mg_bolts.apply_player_reaping(hitter, damage)
    player:set_hp(player:get_hp() - damage)
  end

  return true
end)

