-- How the lighting radius of the level works
-- TODO - ring of light will effect this
local startY = 0

local function calc_player_right_radius(player)
  local meta = player:get_meta()
  local depth = meta:get_int("current_level")

  local radius = mg_arch.DCOLS - 1
  for _ = 1, depth do
    -- radius = radius * 85 / 100
    -- since goal is level 10 - have it get darker sooner
    radius = radius * 70 / 100
  end

  radius = math.ceil(radius + 225 / 100)

  local light_bonus = mg_rings.get_player_light_bonus(player)

  -- Cursed makes it worse
  if light_bonus < 0 then
    radius = radius / (-1 * light_bonus + 1)
    -- Blessed makes it better
  elseif light_bonus > 0 then
    radius = math.max(radius*light_bonus, light_bonus * 2 + 2)
  end
  return radius
end

local function update_player_lighting(player, lightGrids)
  local player_pos = player:get_pos()
  local meta = player:get_meta()
  local depth = meta:get_int("current_level")

  local radius = calc_player_right_radius(player)

  local x = math.floor(player_pos.x + 0.5)
  local z = math.floor(player_pos.z + 0.5)

  -- Have a little bigger than radius to turn off
  -- lights outside of raduis
  local startx = x - math.ceil(radius*1.25)
  local endx = x + math.ceil(radius*1.25)
  local startz = z - math.ceil(radius*1.25)
  local endz = z + math.ceil(radius*1.25)

  local levelLightGrid = lightGrids[depth]
  if levelLightGrid == nil then
    levelLightGrid = mg_arch.allocGrid()
    lightGrids[depth] = levelLightGrid
  end

  for i=startx, endx do
    for j=startz, endz do
      if (x-i)*(x-i) + (z-j)*(z-j) <= radius*radius then
        local isInMap = mg_arch.coordinatesAreInMap(i, j)
        if isInMap then
          levelLightGrid[i][j] = 1
        end
      end
    end
  end
end

local timer = 0


-- This might be a performance killer
-- expecially on higher depths
-- only update 1 / second for now
-- might need to load this in a voxmanip object
-- for better performance
-- also need to figure out how to turn off the lights
-- of a previous level - they stay on when you go down or up
core.register_globalstep(function(dtime)
  timer = timer + dtime
  if timer < 1 then
    return
  end
  timer = 0

  -- ignore if we haven't generated anything levels yet
  -- they will get generated a little bit after
  -- the player has joined
  if mg_arch.dungeon.NUMBER_GENERATED_LEVELS == 0 then
    return
  end

  -- light grids accumlates the light grid per level players are on
  -- lightGrids[level] = grid
  local lightGrids = {}

  for _, player in pairs(core.get_connected_players()) do
    -- lightGrids gets mutated in this function
    update_player_lighting(player, lightGrids)
  end

  local counter = 0

  for depth, lightGrid in pairs(lightGrids) do
    local baseY = -11 * (depth - 1) + startY
    for i=1, mg_arch.DCOLS do
      for j=1, mg_arch.DROWS do
        local pos = { x = i, y = baseY + 8, z = j }
        local node = core.get_node(pos)
        local is_light = lightGrid[i][j]
        if node.name == 'air' and is_light > 0 then
          counter = counter + 1
          core.set_node(pos, {name="mg_torch:air_light_8"})
        elseif node.name == 'mg_torch:air_light_8' and is_light == 0 then
          counter = counter + 1
          core.set_node(pos, {name="air"})
        end
      end
    end
  end
  --print('update ' .. counter .. ' nodes for light')
end)

mg_light = {}
mg_light.calc_player_right_radius = calc_player_right_radius
