-- adapted from brogue code
-- used

local function coordinatesAreInMap (pmap, x, y)
  return x > 0 and y > 0 and x < #pmap and y < #pmap[1]
end

--local function printTable (table)
  --print(json.encode(table))
--end


local function betweenOctant1andN(x, y, x0, y0, n)
  local x1 = x
  local y1 = y
  local dx = x1 - x0
  local dy = y1 - y0
  if n == 1 then
    return x, y
  elseif n == 2 then
    return x, y0 - dy
  elseif n == 5 then
    return x0 - dx, y0 - dy
  elseif n == 6 then
    return x0 - dx, y
  elseif n == 8 then
    return x0 - dy, y0 - dx
  elseif n == 3 then
    return x0 - dy, y0 + dx
  elseif n == 7 then
    return x0 + dy, y0 - dx
  elseif n == 4 then
    return x0 + dy, y0 + dx
  end
end

local LOS_SLOPE_GRANULARITY = 32768

local function scanOctantFOV(
  pmap, grid, xLoc, yLoc, octant, maxRadius,
  columnsRightFromOrigin, startSlope, endSlope,
  cautiousOnWalls
)
  local loc = {x = xLoc, y = yLoc}
  if columnsRightFromOrigin >= maxRadius then
    return
  end

  local newStartSlope = startSlope
  local a = ((LOS_SLOPE_GRANULARITY / -2 + 1) + startSlope * columnsRightFromOrigin) / LOS_SLOPE_GRANULARITY
  local b = ((LOS_SLOPE_GRANULARITY / -2 + 1) + endSlope * columnsRightFromOrigin) / LOS_SLOPE_GRANULARITY
  local iStart = math.min(a, b)
  local iEnd = math.max(a, b)

  if (columnsRightFromOrigin*columnsRightFromOrigin + iEnd*iEnd) >= maxRadius*maxRadius then
    return
  end

  if (columnsRightFromOrigin*columnsRightFromOrigin + iStart*iStart) >= maxRadius*maxRadius then
    iStart = -1* math.sqrt(maxRadius*maxRadius - columnsRightFromOrigin*columnsRightFromOrigin)
  end

  local x = math.ceil(loc.x  + columnsRightFromOrigin)
  local y = math.ceil(loc.y + iStart)
  x, y = betweenOctant1andN(x, y, loc.x, loc.y, octant)

  local currentlyLit = coordinatesAreInMap(pmap, x, y) and pmap[x][y] == 'air'

  for i=iStart, iEnd do
    x = math.ceil(loc.x + columnsRightFromOrigin)
    y = math.ceil(loc.y + i)
    x, y = betweenOctant1andN(x, y, loc.x, loc.y, octant)
    if coordinatesAreInMap(pmap, x, y) then
      local cellObstructed = pmap[x][y] ~= 'air'
      grid[x][y] = 1
      if not cellObstructed and not currentlyLit then
        newStartSlope = (LOS_SLOPE_GRANULARITY * i - LOS_SLOPE_GRANULARITY / 2) / (columnsRightFromOrigin * 2 + 1) * 2
        currentlyLit = true
      elseif cellObstructed and currentlyLit then
        local newEndSlope = (LOS_SLOPE_GRANULARITY * i - LOS_SLOPE_GRANULARITY / 2) / (columnsRightFromOrigin * 2 - 1) * 2
        if newStartSlope <= newEndSlope then
          scanOctantFOV(pmap, grid, loc.x, loc.y, octant, maxRadius, columnsRightFromOrigin + 1, newStartSlope, newEndSlope, cautiousOnWalls)
        end
        currentlyLit = false
      end
    end
  end
  if currentlyLit then
    local newEndSlope = endSlope
    if newStartSlope <= newEndSlope then
        scanOctantFOV(pmap, grid, loc.x, loc.y, octant, maxRadius, columnsRightFromOrigin + 1, newStartSlope, newEndSlope, cautiousOnWalls)
    end
  end
end

local function getFOVMask(pmap, grid, xLoc, yLoc, maxRadius, cautiousOnWalls)
  for i=1, 8 do
    scanOctantFOV(
      pmap, grid, xLoc, yLoc, i, maxRadius,
      1, LOS_SLOPE_GRANULARITY * -1, 0,
      cautiousOnWalls
    )
  end
end

local function mk_grid(pmap)
  local grid = {}
  for i=1, #pmap do
    grid[i] = {}
    for j=1, #pmap[1] do
      grid[i][j] = 0
    end
  end
  return grid
end

-- This is expensive, it doesnt really change - I could cache this...
local function mk_pmap(minp, maxp, y)
	local xsize, zsize = maxp.x - minp.x + 1, maxp.z - minp.z + 1
	local xstep, zstep = 1, 1
  local pmap = {}
  for x = 1, xsize, xstep do
    local map_x = minp.x + x - 1
    pmap[x] = {}
    for z = zsize, 1, -zstep do
      local map_z = minp.z + z - 1
      local nodename = 'air'
      if map_z < mg_arch.DROWS + 1 and
         map_x < mg_arch.DCOLS + 1
      then
        local node = core.get_node({x = map_x, y = y+1, z = map_z})
        nodename = node.name
      end
      pmap[x][z] = nodename
    end
  end
  return pmap
end

local function calc_fov_grid(minp, maxp, pos, radius)
  local xLoc = math.floor(pos.x + 0.5)
  local yLoc = math.floor(pos.z + 0.5)
  local pmap = mk_pmap(minp, maxp, pos.y)
  local fovGrid = mk_grid(pmap)
  getFOVMask(pmap, fovGrid, xLoc, yLoc, math.floor(radius + 0.5), false)

  return fovGrid
end

return {
  calc_fov_grid = calc_fov_grid
}
