local mod_path = minetest.get_modpath("mg_mobs")
local bolts = dofile(mod_path.."/ai_bolts.lua")
local tools = dofile(mod_path.."/ai_tools.lua")

local can_punch = tools.can_punch
local get_punch_target = tools.get_punch_target

local function clamp(x, low, high)
  return math.min(high, math.max(x, low))
end

local function rand_percent(percent)
  return math.random(0,99) < clamp(percent, 0, 100)
end

local function has_los(mob_pos, target_pos)
  -- only nodes - no object or liques
  local cast = core.raycast(mob_pos, target_pos, false, false)
  local thing = cast:next()
  while thing do
    if thing.type == "node" then
      local node = core.get_node(thing.intersection_point)
      local def = minetest.registered_nodes[node.name]
      -- A walkable node is a solid node
      if def and def.walkable then
        print('node in the way ' .. node.name)
        return false
      end
    end
    thing = cast:next()
  end
  return true
end


local function check_stealth(self, dist, stealth_range)
  if dist >= stealth_range * 2 and rand_percent(3) then
    return true
  end
  if dist > stealth_range * 3 then
    return true
  end
end

local function should_end_hunt(self, tgtobj, dist)
  if mobkit.timer(self,1) then
    local stealth_range = mg_stealth.get_stealth(tgtobj)
    local end_hunting = check_stealth(self, dist, stealth_range)
    if end_hunting then
      return true
    end
  end
  return false
end


function mg_mobs.hq_confused(mob, prty)
  local target_pos = nil
  local func = function(self)
    if not mg_oe.has_effect("confusion", self.object) then
      return true
    end
    -- if not confused, return true
    if mobkit.is_queue_empty_low(self) then
      -- pick random direction and times by 2
      local pos = self.object:get_pos()
      local random_yaw = math.random() * 2 * math.pi
      target_pos = vector.add(
        pos,
        vector.multiply(
          core.yaw_to_dir(random_yaw),
          3
        )
      )
      local yaw = self.object:get_yaw()
		  local tyaw = core.dir_to_yaw(
        vector.direction(pos,target_pos))
      if math.abs(tyaw-yaw) > 1 then
        mobkit.lq_turn2pos(self, target_pos)
      end
      mobkit.lq_dumbwalk(self, target_pos, 0.6)
      mobkit.lq_idle(self, 0.1)
    end

    -- if another mob or player is infront of the mob
    -- punch them
    -- do a raycast with target range and get a valid target to punch
    local attack_delay = self.attack_delay or 10
    if self.punch_timer > attack_delay / 10 then
      print('try to punch if theres a target in front of mob for ' .. mob.name .. ' ' .. mob.mg_id)
      local pos = mobkit.get_middle_pos(self)
      local yaw = self.object:get_yaw()
      local dir = minetest.yaw_to_dir(yaw)
      local apos = mobkit.pos_translate2d(pos, yaw, self.attack.range)
      local target = get_punch_target(self, pos, apos)
      if target then
        local target_mob = target:get_luaentity()
        if target_mob then
          print('try to punch this mob ' .. target_mob.name .. ' ' .. target_mob.mg_id)
        end

        -- atually puched tartget so reset timer here
        self.punch_timer = 0
        target:punch(self.object, 1, self.attack)
        -- bounce off
        local vy = self.object:get_velocity().y
        self.object:set_velocity({x=dir.x*-3,y=vy,z=dir.z*-3})
        -- play attack sound if defined
        mobkit.make_sound(self,'attack')
      end
    end
  end
  mobkit.queue_high(mob, func, prty)
end

function mg_mobs.hq_runfrom(self,prty,tgtobj, dist)
  local init=true
  dist = dist or self.view_range*1.1
  local func = function(self)
    if not mobkit.is_alive(tgtobj) then return true end

    -- use abilities when running away
    bolts.use_abilities(self, tgtobj)

    if init then
      mobkit.make_sound(self,'scared')
      init=false
      return
    end

    if mobkit.is_queue_empty_low(self) and self.isonground then
      local pos = mobkit.get_stand_pos(self)
      local opos = tgtobj:get_pos()
      if vector.distance(pos,opos) < dist then
        local tpos = {x=2*pos.x - opos.x,
        y=opos.y,
        z=2*pos.z - opos.z}
        mobkit.goto_next_waypoint(self,tpos)
      else
        self.object:set_velocity({x=0,y=0,z=0})
        return true
      end
    end
  end
  mobkit.queue_high(self,func,prty)
end

local function lq_waterattack(self,height,target)
  local init=true
  -- if take more than two seconds, get out of this
  local timer = 0
  local func=function(self)
    if not mobkit.is_alive(target) then return true end

    -- fail safe timer
    timer = timer + self.dtime
    if timer > 1 then
      return true
    end
    if init then
      local dir = minetest.yaw_to_dir(self.object:get_yaw())
      dir=vector.multiply(dir, self.speed)
      dir.y = -mobkit.gravity*math.sqrt(height*2/-mobkit.gravity)
      self.object:set_velocity(dir)
      mobkit.make_sound(self,'charge')
      init=false
    else
      local pos = self.object:get_pos()
      -- calculate attack spot
      local yaw = self.object:get_yaw()
      local dir = minetest.yaw_to_dir(yaw)
      local apos = mobkit.pos_translate2d(pos,yaw,self.attack.range)

      -- mob hit target
      if can_punch(pos, apos, target) then	--bite
        -- atually puched tartget so reset timer here
        self.punch_timer = 0
        target:punch(self.object,1,self.attack)
        -- bounce off
        local vy = self.object:get_velocity().y
        self.object:set_velocity({x=dir.x*-3,y=vy,z=dir.z*-3})
        -- play attack sound if defined
        mobkit.make_sound(self,'attack')
        if mg_oe.has_effect("discordant", self.object) then
          mobkit.clear_queue_high(self)
        end
        return true
      end
    end
  end
  mobkit.queue_low(self,func)
end

local function lq_jumpattack(self,height,target)
  local init=true
  -- if take more than two seconds, get out of this
  local timer = 0
  local func=function(self)
    if not mobkit.is_alive(target) then return true end

    -- fail safe timer
    timer = timer + self.dtime
    if timer > 1 then
      return true
    end
    if self.isonground then
      -- start jump towards target
      if init then
        local dir = minetest.yaw_to_dir(self.object:get_yaw())
        dir=vector.multiply(dir, self.speed)
        dir.y = -mobkit.gravity*math.sqrt(height*2/-mobkit.gravity)
        self.object:set_velocity(dir)
        mobkit.make_sound(self,'charge')
        init=false
      else
        -- Missed the attack
        mobkit.lq_idle(self,0.1)
        return true
      end
    else

      local pos = mobkit.get_middle_pos(self)
      -- calculate attack spot
      local yaw = self.object:get_yaw()
      local dir = core.yaw_to_dir(yaw)
      local apos = mobkit.pos_translate2d(pos,yaw,self.attack.range)

      -- mob hit target
      if can_punch(pos, apos, target) then	--bite
        print('punch timer ' .. self.punch_timer)
        -- atually puched tartget so reset timer here
        self.punch_timer = 0
        target:punch(self.object,1,self.attack)
        -- bounce off
        local vy = self.object:get_velocity().y
        self.object:set_velocity({x=dir.x*-3,y=vy,z=dir.z*-3})
        -- play attack sound if defined
        mobkit.make_sound(self,'attack')

        -- if the mob lands the punch and is discordant, then
        -- clear the queue so they can pick a new target
        if mg_oe.has_effect("discordant", self.object) then
          mobkit.clear_queue_high(self)
        end
        return true
      end
    end
  end
  mobkit.queue_low(self,func)
end

local function hq_attack(self,prty,tgtobj)
  local func = function(self)
    if not mobkit.is_alive(tgtobj) then return true end
    if mobkit.is_queue_empty_low(self) then

      -- also try to use ability in hq attack func
      bolts.use_abilities(self, tgtobj)

      local pos = mobkit.get_stand_pos(self)
      local tpos = mobkit.get_stand_pos(tgtobj)
      local dist = vector.distance(pos,tpos)
      -- not close enough, go back to hunting
      if dist > 3 then
        return true
      end

      -- can't attack yet, go back to hunting
      local attack_delay = self.attack_delay or 10
      if self.punch_timer < attack_delay / 10 then
        return true
      end

      mobkit.lq_turn2pos(self,tpos)
      local height = tgtobj:is_player() and 0.35 or tgtobj:get_luaentity().height*0.6

      if tpos.y+height > pos.y then
        -- try water attack if in liquid
        if self.isinliquid then
          lq_waterattack(self,tpos.y+height-pos.y,tgtobj)
        else
          lq_jumpattack(self,tpos.y+height-pos.y,tgtobj)
        end
      else
        -- This is confusing
        mobkit.lq_dumbwalk(
          self,
          mobkit.pos_shift(tpos,{x=math.random()-0.5,z=math.random()-0.5})
        )
      end
    end
  end
  mobkit.queue_high(self,func,prty)
end

local function hq_swimto_tgt(self,prty, tgtobj)
	local box = self.object:get_properties().collisionbox
	local cols = {}
	local func = function(self)
		if not self.isinliquid then
			if self.isonground then return true end
			return false
		end

    local tpos = tgtobj:get_pos()

    if not tpos then
      return true
    end

		local pos = mobkit.get_stand_pos(self)
		local y = self.object:get_velocity().y
		local pos2d = {x=pos.x,y=tpos.y,z=pos.z}
		local dir = vector.normalize(vector.direction(pos2d,tpos))
		local yaw = minetest.dir_to_yaw(dir)

    local dist = vector.distance(pos,tpos)

    -- Attack if close enough
    if dist < 3 then
      hq_attack(self, prty+1, tgtobj)
      return
    end

    -- once a second check to see if can
    -- jump out of water
		if mobkit.timer(self,1) then
			cols = mobkit.get_box_displace_cols(pos,box,dir,1)
			for _,p in ipairs(cols[1]) do
				p.y=pos.y
				local h = mobkit.get_terrain_height(p)
				if h and h>pos.y and self.isinliquid then
					mobkit.lq_freejump(self)
					break
				end
			end
		elseif mobkit.turn2yaw(self,yaw) then
			dir.y = y
			self.object:set_velocity(dir)
		end
	end
	mobkit.queue_high(self,func,prty)
end

local function hq_swimto_liquid(self,prty,tpos)
	local box = self.object:get_properties().collisionbox
	local cols = {}
	local func = function(self)
		local pos = mobkit.get_stand_pos(self)
    if vector.distance(pos, tpos) < 1 then
      return true
    end

		local y=self.object:get_velocity().y
		local pos2d = {x=pos.x,y=tpos.y,z=pos.z}
		local dir=vector.normalize(vector.direction(pos2d,tpos))
		local yaw = minetest.dir_to_yaw(dir)

		if mobkit.timer(self,1) then
			cols = mobkit.get_box_displace_cols(pos,box,dir,1)
			for _,p in ipairs(cols[1]) do
				p.y=pos.y
				local h = mobkit.get_terrain_height(p)
				if h and h>pos.y and self.isinliquid then
					mobkit.lq_freejump(self)
					break
				end
			end
		elseif mobkit.turn2yaw(self,yaw) then
			dir.y = y
			self.object:set_velocity(dir)
		end
	end
	mobkit.queue_high(self,func,prty)
end

function mg_mobs.hq_pathfind_land(self,prty,tgtobj)
  local next_pos = nil
  local target_pos = nil
  local path = {}

	local func = function(self)
		if not mobkit.is_alive(tgtobj) then return true end
    -- waiting for the low queue to finish
		if mobkit.is_queue_empty_low(self) and (self.isonground or self.isinliquid) then
			local pos = mobkit.get_stand_pos(self)
			local opos = tgtobj:get_pos()
      --local los_check = has_los(pos, opos)

      -- follow did its job - all done
      if vector.distance(pos,opos) <= 3 then
        return true
      end



      -- reset path if target has moved from orginal path target more than 3
      -- spaces
      if #path == 0 or (target_pos and vector.distance(opos, target_pos) > 3) then
        path = core.find_path(pos, opos, 40, 1, 1)
        if path then
          next_pos = path[1]
          target_pos = opos
          table.remove(path, 1)
        else
          next_pos = opos
          path = {}
        end
      end

      if vector.distance(pos, next_pos) < 1 then
        if #path > 0 then
          next_pos = path[1]
          table.remove(path, 1)
        end
      end

      if self.isinliquid then
        local next_node = mobkit.nodeatpos(next_pos)
        if next_node.drawtype == 'liquid' then
          hq_swimto_liquid(self, prty + 1, next_pos)
        else
          mobkit.hq_swimto(self, prty + 1, next_pos)
        end
      else
        -- also if next_pos is higher than
        -- where the mob is, jump to it
        if next_pos.y - pos.y >= 0.5 then
          mobkit.lq_turn2pos(self, next_pos)
          mobkit.lq_dumbjump(self, 1)
        else
          local yaw = self.object:get_yaw()
          local tyaw = core.dir_to_yaw(
            vector.direction(pos,next_pos))
          if math.abs(tyaw-yaw) > 1 then
            mobkit.lq_turn2pos(self, next_pos)
          end
          mobkit.lq_dumbwalk(self, next_pos, 0.6)
        end
      end

		end
	end
	mobkit.queue_high(self,func,prty)
end

function mg_mobs.hq_follow_land(self,prty,tgtobj)
	local func = function(self)
		if not mobkit.is_alive(tgtobj) then return true end
    -- waiting for the low queue to finish
		if mobkit.is_queue_empty_low(self) and (self.isonground or self.isinliquid) then
			local pos = mobkit.get_stand_pos(self)
			local opos = tgtobj:get_pos()
      --local los_check = has_los(pos, opos)

      -- follow did its job - all done
      if vector.distance(pos,opos) <= 3 then
        mobkit.lq_idle(self,1)
        return
      end

      mg_mobs.hq_pathfind_land(self, prty + 1, tgtobj)
		end
	end
	mobkit.queue_high(self,func,prty)
end



function mg_mobs.hq_hunt(self, prty, tgtobj)
  local func = function(self)
    if not mobkit.is_alive(tgtobj) then return true end
    if mobkit.is_queue_empty_low(self) then
      local pos = mobkit.get_stand_pos(self)
      local opos = mobkit.get_stand_pos(tgtobj)
      local dist = vector.distance(pos,opos)

      -- TODO - if mob is an ally should end hunt
      -- if their player is out of sight or more than 1.5*stealth distance away
      if should_end_hunt(self, tgtobj, dist) then
        return true
      end

      bolts.use_abilities(self, tgtobj)


      local maintains_distance = self.behaviors and self.behaviors.maintains_distance

      if self.isinliquid then
        -- this gets a little weird
        hq_swimto_tgt(self, prty+1, tgtobj)
      -- check every step
      elseif maintains_distance and dist > 6 and self.isonground then
        mobkit.goto_next_waypoint(self,opos)
      elseif maintains_distance and dist < 4 and self.isonground then
        -- want to go away from target
        mg_mobs.hq_runfrom(self, prty+1, tgtobj, 4)
      -- if between 3 - 5 blocks away, then chill out
      elseif maintains_distance and self.isonground then
        -- turn to face player if not facing
        -- then chill out
        local yaw = self.object:get_yaw()
        local tyaw = minetest.dir_to_yaw(vector.direction(pos,opos))
        if math.abs(tyaw-yaw) > 1 then
          mobkit.lq_turn2pos(self,opos)
          mobkit.lq_idle(self,0.1)
          return
        end
        -- if already facing player, chill out
				mobkit.lq_idle(self,0.1)
        return
      elseif dist > 3 then
        local los = has_los(pos, opos)
        if not los and self.isonground then
          mobkit.goto_next_waypoint(self,opos)
        else
          mg_mobs.hq_pathfind_land(self, prty + 1, tgtobj)
        end
      elseif self.isonground then
        -- prevents mobs from attacking too fast
        hq_attack(self, prty+1, tgtobj)
      end
    end
  end
  mobkit.queue_high(self,func,prty)
end

-- Immobile mobs like turrents and totems
function mg_mobs.hq_static_attack(self, prty, tgtobj)
  local func = function(self)
    if not mobkit.is_alive(tgtobj) then return true end
    if mobkit.is_queue_empty_low(self) then
      local pos = mobkit.get_stand_pos(self)
      local opos = tgtobj:get_pos()
      local dist = vector.distance(pos,opos)

      if should_end_hunt(self, tgtobj, dist) then
        return true
      end

      local used_ability = bolts.use_abilities(self, tgtobj)
      if used_ability then
        if mg_oe.has_effect("discordant", self.object) then
          mobkit.clear_queue_high(self)
          return true
        else
          return
        end
      end

      local epos = self.object:get_pos()
      -- calculate attack spot
      local yaw = self.object:get_yaw()
      local dir = minetest.yaw_to_dir(yaw)
      local apos = mobkit.pos_translate2d(epos,yaw,self.attack.range)

      -- mob hit target
      if can_punch(pos, apos, tgtobj) and self.attack.damage_groups.fleshy > 0 then
        tgtobj:punch(self.object,1,self.attack)
        -- bounce off
        local vy = self.object:get_velocity().y
        self.object:set_velocity({x=dir.x*-3,y=vy,z=dir.z*-3})
        -- play attack sound if defined
        mobkit.make_sound(self,'attack')
        if mg_oe.has_effect("discordant", self.object) then
          mobkit.clear_queue_high(self)
          return true
        end
      end
    end
  end
  mobkit.queue_high(self,func,prty)
end

