minetest.register_entity("mg_mobs:vampire_bat",{
	initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.3, -0.15 + 0.25, -0.3, 0.3, 0.15 + 0.25, 0.3},
    visual = "mesh",
    mesh = "animalia_bat.b3d",
    textures = {"animalia_bat_1.png"},
    visual_size = {x = 10, y = 10},
    static_save = true,
    makes_footstep_sound = true,
  },
	on_step = mobkit.stepfunc,	-- required
	on_activate = mobkit.actfunc,		-- required
  physics = mg_mobs.fly_physics,
	get_staticdata = mobkit.statfunc,
											-- api props
	springiness=0,
	buoyancy = 0.9,
	jump_height = 1.26,
  view_range = 20,
	lung_capacity = 10,			-- seconds

  attack_delay = 10,
	max_speed = 3,
	max_hp = 10,
  regen = 20,
  defense = 25,
  accuracy = 100,
	attack={range=1.5, damage_groups={fleshy=2, fleshy_max=6}},
	sounds = {
		scared='animalia_bat_1',
		hurt = 'animalia_bat_2',
  },
	animation = {
    run={range={x=51,y=69},speed=60,loop=true},
    walk={range={x=51,y=69},speed=30,loop=true},
    stand={range={x=1,y=40},speed=10,loop=true},
    fly={range={x=81,y=99},speed=80,loop=true},
    cling={range={x=110,y=110},speed=80,loop=true},
	},

	brainfunc = mg_mobs.mg_brain,

  bolts = { },
  behaviors = {
    flies = 1,
    flits = 1
  },
  abilities = {
    transference = 1
  },

	on_punch= mg_mobs.handle_on_punch,
  on_death = mg_mobs.on_death,
})

mg_mobs.register_egg("mg_mobs:vampire_bat", "Vampire Bat", 1);

minetest.register_entity("mg_mobs:phantom",{
	initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.3, -0.15 + 0.25, -0.3, 0.3, 0.15 + 0.25, 0.3},
    visual = "mesh",
    mesh = "animalia_bat.b3d",
    textures = {"animalia_bat_4.png"},
    visual_size = {x = 10, y = 10},
    static_save = true,
    makes_footstep_sound = true,
  },
	on_step = mobkit.stepfunc,	-- required
	on_activate = mobkit.actfunc,		-- required
  physics = mg_mobs.fly_physics,
	get_staticdata = mobkit.statfunc,
											-- api props
	springiness=0,
	buoyancy = 0.9,
	jump_height = 1.26,
	view_range = 20,
	lung_capacity = 10,			-- seconds

  attack_delay = 10,
	max_speed = 4,
	max_hp = 35,
  regen = 0,
  defense = 70,
  accuracy = 160,
	attack={range=1.5, damage_groups={fleshy=12, fleshy_max=18}},
	sounds = {
		scared='animalia_bat_1',
		hurt = 'animalia_bat_2',
  },
	animation = {
    run={range={x=51,y=69},speed=60,loop=true},
    walk={range={x=51,y=69},speed=30,loop=true},
    stand={range={x=1,y=40},speed=10,loop=true},
    fly={range={x=81,y=99},speed=80,loop=true},
    cling={range={x=110,y=110},speed=80,loop=true},
	},

	brainfunc = mg_mobs.mg_brain,

  invisible_textures = {
    "animalia_bat_4.png"
  },
  visible_textures = {
    "animalia_bat_3.png"
  },

  bolts = { },
  behaviors = {
    flies = 1,
    flits = 1,
    invisible = 1,
  },
  abilities = { },

	on_punch= mg_mobs.handle_on_punch,
  on_death = mg_mobs.on_death,
})

mg_mobs.register_egg("mg_mobs:phantom", "Phantom", 1);

minetest.register_entity("mg_mobs:fury",{
	initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.4, -0.15 + 0.3, -0.4, 0.4, 0.15 + 0.3, 0.4},
    visual = "mesh",
    mesh = "animalia_bat.b3d",
    textures = {"animalia_bat_5.png"},
    visual_size = {x = 15, y = 15},
    static_save = true,
    makes_footstep_sound = true,
  },
	on_step = mobkit.stepfunc,	-- required
	on_activate = mobkit.actfunc,		-- required
  physics = mg_mobs.fly_physics,
	get_staticdata = mobkit.statfunc,
											-- api props
	springiness=0,
	buoyancy = 0.9,
	jump_height = 1.26,
	view_range = 20,
	lung_capacity = 10,			-- seconds

  attack_delay = 10,
	max_speed = 3,
	max_hp = 19,
  regen = 20,
  defense = 110,
  accuracy = 200,
	attack={range=1.2, damage_groups={fleshy=6, fleshy_max=11}},
	sounds = {
		scared='animalia_bat_1',
		hurt = 'animalia_bat_2',
  },
	animation = {
    run={range={x=51,y=69},speed=60,loop=true},
    walk={range={x=51,y=69},speed=30,loop=true},
    stand={range={x=1,y=40},speed=10,loop=true},
    fly={range={x=81,y=99},speed=80,loop=true},
    cling={range={x=110,y=110},speed=80,loop=true},
	},

	brainfunc = mg_mobs.mg_brain,

  bolts = { },
  behaviors = {
    flies = 1,
  },
  abilities = { },

	on_punch= mg_mobs.handle_on_punch,
  on_death = mg_mobs.on_death,
})

mg_mobs.register_egg("mg_mobs:fury", "Fury", 1);

