minetest.register_entity("mg_mobs:spectral_blade",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.2, -0.15 + 0.25, -0.2, 0.2, 1, 0.2},
    visual = "mesh",
    mesh = "sword_common.obj",
    textures = {"mapgen_sand.png"},
    visual_size = {x = 10, y = 10},
    static_save = true,
    makes_footstep_sound = true,
  },
	on_step = mobkit.stepfunc,	-- required
	on_activate = mobkit.actfunc,		-- required
  physics = mg_mobs.fly_physics,
	get_staticdata = mobkit.statfunc,
											-- api props
	springiness=0,
	buoyancy = 0.4,
	max_speed = 3,
	jump_height = 1.26,
	view_range = 20,
	lung_capacity = 10,			-- seconds
	max_hp = 1,
	attack={range=1 ,damage_groups={fleshy=1}},
	sounds = {
		scared='animalia_bat_1',
		hurt = 'animalia_bat_2',
  },
	animation = {},

	brainfunc = mg_mobs.mg_brain,

  bolts = { },
  behaviors = {
    flies = 1,
    dies_if_negated = 1,
    dies_on_leader_death = 1
  },
  abilities = {
  },

	on_punch= mg_mobs.handle_on_punch,
  on_death = mg_mobs.on_death,
})

mg_mobs.register_egg("mg_mobs:spectral_blade", "Blade", 1);

minetest.register_entity("mg_mobs:guardian_spirit",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = false,
    collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
    visual = "mesh",
    mesh = "mg_mobs_armor_character.b3d",
    textures = {
      "mapgen_sand.png",
      "3d_armor_trans.png",
      "3d_armor_trans.png",
      "voxeldungeon_tool_weapon_battleaxe.png"
    },
    visual_size = {x = 1, y = 1},
    static_save = true,
  },
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.4,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 20,
  lung_capacity = 10,			-- seconds

  max_hp = 2000,
  regen= 0,
  defense = 0,
  accuracy = 200,
  attack={range=1.5,damage_groups={fleshy=5, fleshy_max=12}},
  sounds = {
    warn='mobs_mc_pillager_grunt1',
    hurt = 'mobs_mc_pillager_ow1',
  },
  animation = {
    run={range={x=168,y=187},speed=60,loop=true},
    walk={range={x=168,y=187},speed=30,loop=true},
    stand={range={x=0,y=79},speed=30,loop=true},
  },

  bolts = {},
  behaviors = {
    immune_to_weapons = 1,
    dies_if_negated = 1,
    reflective = 1,
  },
  abilities = {},
  allied_to="singleplayer",

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:guardian_spirit", "Guardian Spirit", 1);

