minetest.register_entity("mg_mobs:dar_blademaster",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
    visual = "mesh",
    mesh = "mg_mobs_armor_character.b3d",
    textures = {
      "lottmobs_uruk_hai.png",
      "3d_armor_trans.png",
      "3d_armor_trans.png",
      "voxeldungeon_tool_weapon_sword.png"
    },
    visual_size = {x = 1, y = 1},
    static_save = true,
    makes_footstep_sound = true,
  },
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.4,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 20,
  lung_capacity = 10,			-- seconds

  max_hp = 35,
  regen=10,
  defense = 120,
  accuracy = 160,
  attack={range=1.5,damage_groups={fleshy=2, fleshy_max=12}},
  sounds = {
    warn='mobs_mc_pillager_grunt1',
    hurt = 'mobs_mc_pillager_ow1',
  },
  animation = {
    run={range={x=168,y=187},speed=60,loop=true},
    walk={range={x=168,y=187},speed=30,loop=true},
    stand={range={x=0,y=79},speed=30,loop=true},
  },

  bolts = {
    "blink"
  },
  behaviors = { },
  abilities = {
    avoids_corridors = 1,
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:dar_blademaster", "Dar Mage", 1);

minetest.register_entity("mg_mobs:dar_mage",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
    visual = "mesh",
    mesh = "mg_mobs_armor_character.b3d",
    textures = {
      "lottmobs_uruk_hai_3.png",
      "3d_armor_trans.png",
      "3d_armor_trans.png",
      "mg_staff_protection.png"
    },
    visual_size = {x = 1, y = 1},
    static_save = true,
    makes_footstep_sound = true,
  },
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.4,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 20,
  lung_capacity = 10,			-- seconds

  max_hp = 20,
  regen=20,
  defense = 60,
  accuracy = 160,
  attack={range=1.5,damage_groups={fleshy=2, fleshy_max=5}},

  sounds = {
    warn='mobs_mc_pillager_grunt1',
    hurt = 'mobs_mc_pillager_ow1',
  },
  animation = {
    run={range={x=168,y=187},speed=60,loop=true},
    walk={range={x=168,y=187},speed=30,loop=true},
    stand={range={x=0,y=79},speed=30,loop=true},
  },

  bolts = {
    "negation",
    'healing',
    'haste',
    'spark'
  },
  behaviors = {
    maintains_distance = 1,
  },
  abilities = {
    avoids_corridors = 1,
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:dar_mage", "Dar Mage", 1);

minetest.register_entity("mg_mobs:dar_battlemage",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
    visual = "mesh",
    mesh = "mg_mobs_armor_character.b3d",
    textures = {
      "lottmobs_uruk_hai_2.png",
      "3d_armor_trans.png",
      "3d_armor_trans.png",
      "mg_staff_fire.png"
    },
    visual_size = {x = 1, y = 1},
    static_save = true,
    makes_footstep_sound = true,
  },
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.4,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 20,
  lung_capacity = 10,			-- seconds
  max_hp = 20,
  regen=10,
  defense = 60,
  accuracy = 100,
  attack={range=1.5,damage_groups={fleshy=1, fleshy_max=3}},
  sounds = {
    warn='mobs_mc_pillager_grunt1',
    hurt = 'mobs_mc_pillager_ow1',
  },
  animation = {
    run={range={x=168,y=187},speed=60,loop=true},
    walk={range={x=168,y=187},speed=30,loop=true},
    stand={range={x=0,y=79},speed=30,loop=true},
  },

  bolts = {
    "fire_bolt",
    'slow'
  },
  behaviors = {
    maintains_distance = 1,
  },
  abilities = {
    avoids_corridors = 1,
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:dar_battlemage", "Dar Battlemage", 1);
