minetest.register_entity("mg_mobs:golem",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.4, -0.01, -0.4, 0.4, 1.8, 0.4},
    visual = "mesh",
    mesh = "mobs_mc_iron_golem.b3d",
    textures = { "mobs_mc_iron_golem.png" },
    visual_size = {x = 3, y = 3},
    static_save = true,
    makes_footstep_sound = true,
  },
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.5,					-- portion of hitbox submerged

  jump_height = 1.26,
  view_range = 20,
  lung_capacity = 10, 		-- seconds

  max_speed = 5,
  attack_delay = 10,
  max_hp = 400,
  regen = 0,
  defense = 70,
  accuracy = 225,
  attack={
    range=1,
    damage_groups={
      fleshy=4,
      fleshy_max=8,
      clump=5
    }
  },
  sounds = {
		attack = "mobs_mc_iron_golem_random",
		warn = "mobs_mc_iron_golem_random",
		death = "mobs_mc_iron_golem_death",
		hurt = "mobs_mc_iron_golem_clank_damage",
  },
  animation = {
    run={range={x=0,y=40},speed=25,loop=true},
    walk={range={x=0,y=40},speed=15,loop=true},
    stand={range={x=0,y=0},speed=40,loop=true},
    punch={range={x=40,y=50},speed=15,loop=true},
    death={range={x=0,y=0},speed=15,loop=false},
  },

  bolts = {},
  behaviors = {
    reflective = 1,
    dies_if_negated = 1
  },
  abilities = { },

  brainfunc = mg_mobs.mg_brain,
  on_punch = mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:golem", "Golem", 1);
