minetest.register_entity("mg_mobs:pillager",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.3, -0.01, -0.3, 0.3, 1.98, 0.3},
    visual = "mesh",
    mesh = "mobs_mc_pillager.b3d",
    textures = {
      "mobs_mc_pillager.png" ,
      "mcl_bows_crossbow_3.png^[resize:16x16", -- Wielded item
    },
    visual_size = {x=2.75, y=2.75},
    static_save = true,
    makes_footstep_sound = true,
  },
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.4,
  max_speed = 10,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10,			-- seconds
  max_hp = 35,
  regen=20,
  defense = 50,
  accuracy = 175,
  attack={range=0.5,damage_groups={fleshy=9, fleshy_max=13}},
  sounds = {
		random = "mobs_mc_pillager_grunt2",
		warn = "mobs_mc_pillager_grunt1",
		death = "mobs_mc_pillager_ow2",
		hurt = "mobs_mc_pillager_ow1",
  },
  animation = {
    -- TODO there's animation for loading and unloading
    stand={range={x=101,y=109},speed=30,loop=true},
    walk={range={x=111,y=150},speed=30,loop=true},
    run={range={x=111,y=150},speed=30,loop=true},
  },

  bolts = { 'arrow' },
  behaviors = {
    maintains_distance = 1,
  },
  abilities = {
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

