minetest.register_entity("mg_mobs:snowman",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.35, -0.01, -0.35, 0.35, 2, 0.35},
    visual = "mesh",
    mesh = "mobs_mc_snowman.b3d",
    textures = {"mobs_mc_snowman.png", "blank.png"},
    visual_size = {x = 3, y = 3},
    static_save = true,
    makes_footstep_sound = true,
  },
	on_step = mobkit.stepfunc,	-- required
	on_activate = mobkit.actfunc,		-- required
	get_staticdata = mobkit.statfunc,
											-- api props
	springiness=0,
	buoyancy = 0.4,
	max_speed = 5,
	jump_height = 1.26,
	view_range = 24,
	lung_capacity = 10,			-- seconds
	max_hp = 10,
	attack={range=0.5,damage_groups={fleshy=3}},
	sounds = {
		scared='mobs_mc_cat_hiss',
		hurt = 'mobs_mc_ocelot_hurt',
		},
	animation = {
    die={range={x=40,y=50},speed=25,loop=false},
    run={range={x=0,y=20},speed=50,loop=true},
    walk={range={x=0,y=20},speed=25,loop=true},
    stand={range={x=20,y=40},speed=25,loop=true},
	},

  bolts = { },
  behaviors = {
    dies_if_negated = 1
  },
  abilities = {
  },

	brainfunc = mg_mobs.mg_brain,
	on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:snowman", "Snowman", 1);
