minetest.register_entity("mg_mobs:goblin_totem",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    visual = "mesh",
    mesh = "mg_mobs_double_node.obj",
    textures = {
      "mapgen_tree.png",
      "mcl_observers_observer_front.png"
    },
    visual_size = {x = 10, y = 10, z = 10},
    collisionbox = {-0.5, 0, -0.5, 0.5, 2.0, 0.5},
    static_save = true,
    makes_footstep_sound = false,
  },

	on_step = mobkit.stepfunc,	-- required
	on_activate = mobkit.actfunc,		-- required
	get_staticdata = mobkit.statfunc,
											-- api props
	springiness=0,
	buoyancy = 0.9,
	max_speed = 0,
	jump_height = 1.26,
	view_range = 24,
	lung_capacity = 10,			-- seconds
	max_hp = 30,
  regen = 10,
  defense = 0,
  accuracy = 90,
	attack={range=1,damage_groups={fleshy=0, fleshy_max=0}},
	sounds = {
		hurt = 'mg_mobs_static_hurt',
  },

  bolts = {
    'spark',
    'haste'
  },
  behaviors = {},
  abilities = {
  },

	brainfunc= mg_mobs.mg_brain,
	on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:goblin_totem", "Goblin Totem", 1);

minetest.register_entity("mg_mobs:ogre_totem",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,

    visual = "mesh",
    mesh = "mg_mobs_double_node.obj",
    textures = {
      "mapgen_stone_block.png",
      "mcl_observers_observer_front.png"
    },
    visual_size = {x = 10, y = 10, z = 10},
    collisionbox = {-0.5, 0, -0.5, 0.5, 2.0, 0.5},

    static_save = true,
    makes_footstep_sound = false,
  },

	on_step = mobkit.stepfunc,	-- required
	on_activate = mobkit.actfunc,		-- required
	get_staticdata = mobkit.statfunc,
											-- api props
	springiness=0,
	buoyancy = 0.9,
	max_speed = 0,
	jump_height = 1.26,
	view_range = 24,
	lung_capacity = 10,			-- seconds
	max_hp = 30,
  regen = 10,
  defense = 0,
  accuracy = 90,
	attack={range=1,damage_groups={fleshy=0, fleshy_max=0}},
	sounds = {
		hurt = 'mg_mobs_static_hurt',
  },

  bolts = {
    'healing',
    'slow'
  },
  behaviors = {},
  abilities = {
  },

	brainfunc= mg_mobs.mg_brain,
	on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:ogre_totem", "Ogre Totem", 1);
