
local function register_turret(name, def)
  local ename = "mg_mobs:" .. name .. "_turret"
  print('register ' .. ename)
  core.register_entity(ename,{
    initial_properties = {
      physical = true,
      stepheight = 0.1,				--EVIL!
      collide_with_objects = true,

      visual = "mesh",
      mesh = "mg_mobs_double_node.obj",
      textures = {
        "mapgen_stone_block.png",
        "mcl_dispensers_dispenser_front_horizontal.png"
      },
      visual_size = {x = 10, y = 10, z = 10},
      collisionbox = {-0.5, 0, -0.5, 0.5, 2.0, 0.5},

      static_save = true,
      makes_footstep_sound = false,
    },

    on_step = mobkit.stepfunc,	-- required
    on_activate = mobkit.actfunc,		-- required
    get_staticdata = mobkit.statfunc,
                        -- api props
    springiness=0,
    buoyancy = 0.9,
    max_speed = 0,
    jump_height = 1.26,
    view_range = 100,
    lung_capacity = 10,			-- seconds
    max_hp = def.max_hp or 30,
    regen = 0,
    defense = 0,
    accuracy = 90,
    attack={range=1,damage_groups={fleshy=0, fleshy_max=0}},
    sounds = {
      hurt = 'dig_cracky',
    },

    bolts = { def.bolt },
    behaviors = {
      in_wall = 1,
      immune_to_fire = 1,
    },
    abilities = {
    },

    brainfunc= mg_mobs.mg_brain,
    on_punch= mg_mobs.handle_on_punch,
  })

  mg_mobs.register_egg("mg_mobs:"..name.."_turret", def.description, 1);
end

register_turret("arrow", {bolt = "arrow", max_hp = 30, description="Arrow Turret"})
register_turret("spark", {bolt = "spark", max_hp = 80, description="Spark Turret"})
register_turret("steel_arrow", {bolt = "steel_arrow", max_hp = 40, description="Steel Arrow Turret"})
register_turret("fire_bolt", {bolt = "fire_bolt", max_hp = 40, description="Fire Bolt Turret"})
