local abs = math.abs

minetest.register_entity("mg_mobs:wisp",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.3, -0.01, -0.3, 0.3, 0.8, 0.3},
    visual = "mesh",
    mesh = "mobs_mc_blaze.b3d",
    textures = {
      "mobs_mc_blaze.png"
    },
    visual_size = {x=1, y=1},
    static_save = true,
    makes_footstep_sound = true,
  },
	on_step = mobkit.stepfunc,	-- required
	on_activate = mobkit.actfunc,		-- required
	get_staticdata = mobkit.statfunc,
  physics = mg_mobs.fly_physics,
	springiness=0,
	buoyancy = 0.8,
	max_speed = 3,
	jump_height = 1.26,
	view_range = 20,
	lung_capacity = 10,			-- seconds
	max_hp = 10,
  regen=5,
  defense = 90,
  accuracy = 100,
	attack={range=1,damage_groups={fleshy=1}},
	sounds = {
		warn = "mobs_mc_blaze_breath",
		death = "mobs_mc_blaze_died",
		hurt = "mobs_mc_blaze_hurt",
  },
	animation = {
    fly={range={x=1,y=40},speed=1,loop=true},
    walk={range={x=1,y=40},speed=1,loop=true},
    stand={range={x=1,y=40},speed=1,loop=true},
	},

  bolts = {},
  behaviors = {
    immune_to_fire = 1,
    flies = 1,
    flits = 1,
    never_sleeps = 1,
    fiery = 1,
    dies_if_negated = 1
  },
  abilities = {
    hit_burn = 1
  },

	brainfunc = mg_mobs.mg_brain,
	on_punch = mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:wisp", "Wisp", 1);
