minetest.register_entity("mg_mobs:wraith",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.3, -0.01, -0.3, 0.3, 1.98, 0.3},
    visual = "mesh",
    mesh = "mobs_mc_stray.b3d",
    textures = { "mobs_mc_stray.png^mobs_mc_stray_overlay.png" },
    visual_size = {x = 3, y = 3},
    static_save = true,
    makes_footstep_sound = true,
  },
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.5,					-- portion of hitbox submerged
  max_speed = 10,
  attack_delay = 5,
  jump_height = 1.26,
  view_range = 20,
  lung_capacity = 10, 		-- seconds
  max_hp = 50,
  regen=5,
  defense = 60,
  accuracy = 120,
  attack={
    range=1,
    damage_groups={
      fleshy=6,
      fleshy_max=13,
      clump=2
    }
  },
  sounds = {
    attack='mob_mc_skeleton_random',
    warn='mob_mc_skeleton_random',
    hurt = 'mobs_mc_skeleton_hurt',
    death='mob_mc_skeleton_death',
  },
  animation = {
    run={range={x=40,y=60},speed=30,loop=true},
    walk={range={x=40,y=60},speed=15,loop=true},
    stand={range={x=0,y=40},speed=40,loop=true},
    death={range={x=160,y=170},speed=15,loop=false},
  },

  bolts = {},
  behaviors = {
    flees_near_death = 1
  },
  abilities = {
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch = mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:wraith", "Wraith", 1);


minetest.register_entity("mg_mobs:revenant",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.4, 0.4, -0.4, 0.4, 1.8, 0.4},
    visual = "mesh",
    mesh = "mobs_mc_wither.b3d",
    textures = { "mobs_mc_wither.png" },
    visual_size = {x = 4, y = 4},
    static_save = true,
    makes_footstep_sound = true,
  },
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.5,					-- portion of hitbox submerged

  jump_height = 1.26,
  view_range = 20,
  lung_capacity = 10, 		-- seconds

  max_speed = 5,
  attack_delay = 10,
  max_hp = 30,
  regen = 0,
  defense = 0,
  accuracy = 200,
  attack={
    range=1,
    damage_groups={
      fleshy=15,
      fleshy_max=20,
      clump=5
    }
  },
  sounds = {
    attack='mob_mc_skeleton_random',
    warn='mob_mc_skeleton_random',
    hurt = 'mobs_mc_skeleton_hurt',
    death='mob_mc_skeleton_death',
  },
  animation = {
    run={range={x=0,y=20},speed=12,loop=true},
    walk={range={x=0,y=20},speed=12,loop=true},
    stand={range={x=0,y=0},speed=40,loop=true},
    death={range={x=0,y=0},speed=15,loop=false},
  },

  bolts = {},
  behaviors = {
    immune_to_weapons = 1
  },
  abilities = {
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch = mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:revenant", "Revenant", 1);
