-- Fire immunity here for now
local function is_fire_damage(mt_reason)
  if mt_reason.type == "node_damage" and (
    mt_reason.node == "mg_mapgen:magma_flowing" or
    mt_reason.node == "mg_mapgen:magma_source" or
    mt_reason.node == "fire:basic_flame") then
    return true
  end

  if mt_reason.type == "set_hp" and mt_reason._mg_type == "on_fire" then
    return true
  end

  return false
end


local function set_flammable_nodes_on_fire(obj, storage)
  if not storage.duration or storage.duration <= 0 then
    return
  end
  local nodes = mg_oe.get_touching_nodes(obj, {"group:flammable"}, storage)
  for _, pos in pairs(nodes) do
    local p = core.find_node_near(pos, 1, {"air"})
    if p then
      core.set_node(p, {name = "fire:basic_flame"})
      return
    end
  end
end

local function add_hud(player, data)
	local animation_frames = 8
	local hud_flame_animated = "mg_burning_hud_flame_animated.png^[opacity:180^[verticalframe:" .. animation_frames .. ":"

	local storage = data
	if not storage.fire_hud_id then
		storage.animation_frame = 1
		storage.fire_hud_id = player:hud_add({
			hud_elem_type = "image",
			position = {x = 0.5, y = 0.5},
			scale = {x = -100, y = -100},
			text = hud_flame_animated .. storage.animation_frame,
			z_index = 1000,
		})
	end
end

local function update_hud(player, data)
	local animation_frames = 8
	local hud_flame_animated = "mg_burning_hud_flame_animated.png^[opacity:180^[verticalframe:" .. animation_frames .. ":"

	local storage = data
	if storage.fire_hud_id then
		storage.animation_frame = storage.animation_frame + 1
		if storage.animation_frame > animation_frames - 1 then
			storage.animation_frame = 0
		end
		player:hud_change(storage.fire_hud_id, "text", hud_flame_animated .. storage.animation_frame)
	end
end

local function deal_damage(target, amount)
  local mob = target:get_luaentity()

  if target:is_player() then
    local hp = target:get_hp()
    if hp > 0 then
      target:set_hp(hp - amount, {_mg_type = "on_fire"})
    end
  else
    if (mob.hp or -1) > 0  then
      mobkit.make_sound(mob,'hurt')
      mobkit.hurt(mob, amount)
    end
  end
end


mg_oe.register_effect("burning", {
  icon = "mcl_potions_effect_fire_resistance.png",
  default_data = {
    node_timer = 0,
    damage_timer = 0,
    animation_timer = 0,
  },
  on_join = function(def, target)
    local data = def.get_data(target)
    if data.fire_hud_id then
      data.fire_hud_id = nil
    end
    def.set_data(target, data)
  end,
  on_prestart = function(_def, target, _duration)
    if target:get_hp() < 0 then
      return false
    end

    local mob = target:get_luaentity()
    if mob and mob.behaviors and mob.behaviors.immune_to_fire and mob.behaviors.immune_to_fire > 0 then
      return false
    end

    return true
  end,
  on_start = function(def, target, duration)
    local data = def.get_data(target)

    -- reset duration and total timer
    data.duration = duration
    data.total_timer = 0

    local minp, maxp = mg_oe.get_collisionbox(target, false, data)
    local size = vector.subtract(maxp, minp)
    size = vector.multiply(size, vector.new(1.1, 1.2, 1.1))
    size = vector.divide(size, target:get_properties().visual_size)

    local fire_entity = core.add_entity(target:get_pos(), "mg_oe:burning")
    fire_entity:set_properties({visual_size = size})
    fire_entity:set_attach(target, "", vector.new(0, size.y * 5, 0), vector.new(0, 0, 0))

    if target:is_player() then
      add_hud(target, data)
    end

    def.set_data(target, data)
  end,
  on_preclear = function(def, target)
    local data = def.get_data(target)
		if target:is_player() then
			if data.fire_hud_id then
				target:hud_remove(data.fire_hud_id)
			end
    end
  end,
  on_prestep = function(def, target, dt)
    local data = def.get_data(target)
    data.node_timer = (data.node_timer or 0) + dt
    if data.node_timer < 0.1 then
      def.set_data(target, data)
      return
    end
    data.node_timer = 0

    -- probably only run this once a second
    local nodes = mg_oe.get_touching_nodes(
      target,
      {"group:puts_out_fire", "group:set_on_fire"},
      data
    )
    local burn_time = 0

    for _, pos in pairs(nodes) do
      local node = core.get_node(pos)
      if core.get_item_group(node.name, "puts_out_fire") > 0 then
        burn_time = 0
        break
      end

      local value = core.get_item_group(node.name, "set_on_fire")
      if value > burn_time then
        burn_time = value
      end
    end

    if burn_time > 0 then
     -- def.start(target, burn_time)
      mg_oe.start_effect("burning", target, 7)
    end
    def.set_data(target, data)
  end,
  on_step = function(def, target, dt)
    local data = def.get_data(target)
    local water_nodes = mg_oe.get_touching_nodes(
      target, "group:puts_out_fire", data
    )
    if #water_nodes > 0 then
      def.clear(target)
      return
    end

    data.animation_timer = data.animation_timer or 0
    data.animation_timer = data.animation_timer + dt
    if data.animation_timer > 0.1 and target:is_player() then
      data.animation_timer = 0
      update_hud(target, data)
    end

    data.damage_timer = data.damage_timer + dt
    if data.damage_timer >= 1 then
      data.damage_timer = 0
      set_flammable_nodes_on_fire(target, data)
      deal_damage(target, 1)
    end
    def.set_data(target, data)
  end,
})


local fire_immunity = "mg_fire_immunity"

-- This is for fire immunity now for players
core.register_on_player_hpchange(function(player, hp_change, mt_reason)
	if hp_change < 0 then
    local meta = player:get_meta()
    local has_fire_immunity = meta:get_int(fire_immunity)
    local damage_from_fire = is_fire_damage(mt_reason)
    if has_fire_immunity > 0 and damage_from_fire then
      return 0
    end
	end
	return hp_change
end, true)

local animation_frames = 8

core.register_entity("mg_oe:burning", {
	initial_properties = {
		physical = false,
		collisionbox = {0, 0, 0, 0, 0, 0},
		visual = "upright_sprite",
		textures = {
			"mg_burning_entity_flame_animated.png",
			"mg_burning_entity_flame_animated.png"
		},
		spritediv = {x = 1, y = animation_frames},
		pointable = false,
		glow = -1,
		backface_culling = false,
	},
	_mg_animation_timer = 0,
	on_activate = function(self)
		self.object:set_sprite({x = 0, y = 0}, animation_frames, 1.0 / animation_frames)
	end,
	on_step = function(self, dtime)
		local parent = self.object:get_attach()
		if not parent then
			self.object:remove()
			return
		end
		local storage = mg_oe.get_effect_data("burning", parent)
    -- not burning anymore, remove attached entity
		if not storage or not storage.duration or storage.duration == 0 then
			self.object:remove()
			return
		end
		if parent:is_player() then
			self._mg_animation_timer = self._mg_animation_timer + dtime
			if self._mg_animation_timer >= 0.5 then
				self._mg_animation_timer = 0
				--update_hud(parent, storage)
			end
		end
	end,
})
