local function add_spawner(obj, color)
	local d = 0.2
	local pos = obj:get_pos()
	core.add_particlespawner({
		amount = 1,
		time = 1,
		minpos = {x=pos.x-d, y=pos.y+1, z=pos.z-d},
		maxpos = {x=pos.x+d, y=pos.y+2, z=pos.z+d},
		minvel = {x=-0.1, y=0, z=-0.1},
		maxvel = {x=0.1, y=0.1, z=0.1},
		minacc = {x=-0.1, y=0, z=-0.1},
		maxacc = {x=0.1, y=.1, z=0.1},
		minexptime = 0.5,
		maxexptime = 1,
		minsize = 0.5,
		maxsize = 1,
		collisiondetection = false,
		vertical = false,
		texture = "mcl_particles_effect.png^[colorize:"..color..":127",
	})
end

local particle_color = "#4E9331"

mg_oe.register_effect("poison", {
  icon = "mcl_potions_effect_poison.png",
  default_data = {
    node_timer = 0,
    damage = 0,
    damage_timer = 0,
    cooldown_timer = 0
  },
  on_start = function(def, target, duration, damage)
    local data = def.get_data(target)
    local check_cooldown = true

    -- Poison is not currently applied
    -- there's a bug with this right now...
    if not data.damage or data.damage == 0 then
      check_cooldown = false
      data.damage_timer = 0
      data.total_timer = 0

      -- update the hudbar
      if target:is_player() then
        hb.change_hudbar(target, "health", nil, nil, "hbhunger_icon_health_poison.png", nil, "hbhunger_bar_health_poison.png")
      end
    end

    -- 1 second cool down for applying poison effects again
    -- only check cooldown after first poison
    -- maybe should build cooldown into api
    if check_cooldown and (data.cooldown_timer or 0) <= 1 then
      -- duration needs set back to what it was
      data.duration = (data.duration or 0) - duration
      def.set_data(target, data)
      return
    end

    data.cooldown_timer = 0
    data.damage = (data.damage or 0) + damage
    def.set_data(target, data)
  end,
  on_clear = function(_def, target)
    if target:is_player() then
      -- reset hudbar
      hb.change_hudbar(target, "health", nil, nil, "hudbars_icon_health.png", nil, "hudbars_bar_health.png")
    end
  end,
  on_prestep = function(def, target, dt)
    local data = def.get_data(target)
    data.node_timer = (data.node_timer or 0) + dt
    if data.node_timer < 0.1 then
      def.set_data(target, data)
      return
    end
    data.node_timer = 0
    local nodes = mg_oe.get_touching_nodes(target, {"group:poisons"}, data)

    for _, pos in pairs(nodes) do
      local node = core.get_node(pos)
      local node_duration = core.get_item_group(node.name, "poisons")
      if node_duration > 0 then
        def.start(target, node_duration, 1)
        break
      end
    end
    def.set_data(target, data)
  end,
  on_step = function(def, target, dt)
    local data = def.get_data(target)
    --TODO - get touching nodes should be a util function somewhere

    add_spawner(target, particle_color)

    data.damage_timer = data.damage_timer + dt
    data.cooldown_timer = data.cooldown_timer + dt

    if data.damage_timer > 1 then
      data.damage_timer = 0
      -- apply damage
      if target:is_player() then
        local hp = target:get_hp()
        if hp > 0 then
          target:set_hp(hp - data.damage, {_mg_type = "poison"})
        end
      else
        local mob = target:get_luaentity()
        if (mob.hp or -1) > 0 then
          mobkit.make_sound(mob,'hurt')
          mobkit.hurt(mob, data.damage)
        end
      end
    end
    def.set_data(target, data)
  end
})
