-- TODO - being on fire is really just a status effect as well
-- I can migrate the mg_burning mod as an effect I think
local speed = player_monoids.speed

local function add_spawner(obj, color)
	local d = 0.2
	local pos = obj:get_pos()
	core.add_particlespawner({
		amount = 1,
		time = 1,
		minpos = {x=pos.x-d, y=pos.y+1, z=pos.z-d},
		maxpos = {x=pos.x+d, y=pos.y+2, z=pos.z+d},
		minvel = {x=-0.1, y=0, z=-0.1},
		maxvel = {x=0.1, y=0.1, z=0.1},
		minacc = {x=-0.1, y=0, z=-0.1},
		maxacc = {x=0.1, y=.1, z=0.1},
		minexptime = 0.5,
		maxexptime = 1,
		minsize = 0.5,
		maxsize = 1,
		collisiondetection = false,
		vertical = false,
		texture = "mcl_particles_effect.png^[colorize:"..color..":127",
	})
end

local function add_custom_spawner(obj, texture)
	local d = 0.2
	local pos = obj:get_pos()
	core.add_particlespawner({
		amount = 1,
		time = 1,
		minpos = {x=pos.x-d, y=pos.y+1, z=pos.z-d},
		maxpos = {x=pos.x+d, y=pos.y+2, z=pos.z+d},
		minvel = {x=-0.1, y=0, z=-0.1},
		maxvel = {x=0.1, y=0.1, z=0.1},
		minacc = {x=-0.1, y=0, z=-0.1},
		maxacc = {x=0.1, y=.1, z=0.1},
		minexptime = 0.5,
		maxexptime = 1,
		minsize = 0.5,
		maxsize = 1,
		collisiondetection = false,
		vertical = false,
		texture = texture or "mg_oe_confused.png"
	})
end



mg_oe.register_effect("slowness", {
  icon = "mcl_potions_effect_slowness.png",
  default_data = {
    speed = 1
  },
  on_start = function(def, target, reset)
    if target:is_player() then
      speed:add_change(target, 0.5, "mg_oe:half_speed")
    end
    -- for mobs
    local data = def.get_data(target)
    if reset then
      data.speed = 0.5
      data.reset = true
    else
      data.speed = (data.speed or 1) * 0.5
    end
    def.set_data(target, data)
  end,
  on_clear = function(def, target)
    if target:is_player() then
      speed:del_change(target, "mg_oe:half_speed")
    end
    -- for mobs
    local data = def.get_data(target)
    if data.reset then
      data.speed = 1
    else
      data.speed = (data.speed or 1) * 2
    end
    def.set_data(target, data)
  end,
  on_step = function(def, target)
    add_spawner(target, "#5A6C81")
    local data = def.get_data(target)
    if not target:is_player() then
      local mob = target:get_luaentity()
      mob.speed = mob.max_speed * data.speed
    end
  end
})

mg_oe.register_effect("speed", {
  icon = "mcl_potions_effect_swiftness.png",
  default_data = {
    speed = 1,
    reset = false
  },
  on_start = function(def, target, reset)
    if target:is_player() then
      speed:add_change(target, 2, "mg_oe:double_speed")
    end
    -- for mobs
    local data = def.get_data(target)
    if reset then
      data.speed = 2
      data.reset = true
    else
      data.speed = (data.speed or 1) * 2
    end
    def.set_data(target, data)
  end,
  on_clear = function(def, target)
    if target:is_player() then
      speed:del_change(target, "mg_oe:double_speed")
    end
    -- for mobs
    local data = def.get_data(target)
    if data.reset then
      data.speed = 1
    else
      data.speed = (data.speed or 1) * 0.5
    end
    def.set_data(target, data)
  end,
  on_step = function(def, target)
    add_spawner(target, "#7CAFC6")
    local data = def.get_data(target)
    if not target:is_player() then
      local mob = target:get_luaentity()
      mob.speed = mob.max_speed * data.speed
    end
  end
})

-- only for players now
mg_oe.register_effect("invisibility", {
  icon = "mcl_potions_effect_invisibility.png",
  on_start = function(_def, target)
    if target:is_player() then
      mg_stealth.set_invisible(target, 1)
    end
  end,
  on_clear = function(_def, target)
    if target:is_player() then
      mg_stealth.set_invisible(target, 0)
    end
  end
})

local gravity = player_monoids.gravity
mg_oe.register_effect("levitation", {
  icon = "mcl_potions_effect_levitation.png",
  default_data = {
    gravity = 1
  },
  on_start = function(def, target)
    if target:is_player() then
      gravity:add_change(target, -1, "mg_oe:minus_gravity")
    end
    -- for mobs
    local data = def.get_data(target)
    data.gravity = (data.gravity or 1) * 0.5
    def.set_data(target, data)
  end,
  on_clear = function(def, target)
    if target:is_player() then
    gravity:del_change(target, "mg_oe:minus_gravity")
    end
    -- for mobs
    local data = def.get_data(target)
    data.gravity = (data.gravity or 1) * 2
    def.set_data(target, data)
  end
})

local fire_immunity = "mg_fire_immunity"
mg_oe.register_effect("fire_immunity", {
  icon = "mcl_potions_effect_fire_resistance.png",
  default_data = {
    fire_immunity = 0
  },
  on_start = function(def, target)
    if target:is_player() then
      local meta = target:get_meta()
      meta:set_int(fire_immunity, 1)
    end
    -- for mobs
    local data = def.get_data(target)
    data.fire_immunity = 1
    def.set_data(target, data)
  end,
  on_clear = function(def, target)
    if target:is_player() then
      local meta = target:get_meta()
      meta:set_int(fire_immunity, 0)
    end
    -- for mobs
    local data = def.get_data(target)
    data.fire_immunity = 0
    def.set_data(target, data)
  end
})

-- TODO need to stack weakness
mg_oe.register_effect("weakness", {
  icon = "mcl_potions_effect_weakness.png",
  cannot_negate = true,
  default_data = {
    weakness = 0
  },
  on_start = function(def, target)
    if target:is_player() then
      mg_strength.set_weakness(target, 1)
    end
    -- for mobs
    local data = def.get_data(target)
    data.weakness = 1
    def.set_data(target, data)
  end,
  on_clear = function(def, target)
    if target:is_player() then
      mg_strength.set_weakness(target, 0)
    end
    -- for mobs
    local data = def.get_data(target)
    data.weakness = 0
    def.set_data(target, data)
  end
})

mg_oe.register_effect("darkness", {
  icon = "mcl_potions_effect_blindness.png",
  default_data = {
    cool_down = 0,
    range = 0
  },
  on_start = function(def, target, duration, range)
    local data = def.get_data(target)
    data.range = range
    data.duration = duration
    data.cool_down = 0
    if target:is_player() then
      target:set_sky({fog = {
        fog_distance = data.total_timer / data.duration * (data.range or 40),
        fog_start = 0.75,
        fog_color = "#000000"
      }})
    end
    def.set_data(target, data)
  end,
  on_clear = function(_def, target)
    if target:is_player() then
      target:set_sky({fog = {
        fog_distance = -1,
        fog_start = -1,
        fog_color = "#00000000"
      }})
    end
  end,
  on_step = function(def, target, dt)
    local data = def.get_data(target)
    data.cool_down = (data.cool_down or 0) + dt
    if data.cool_down > 0.25 then
      data.cool_down = 0
      if target:is_player() then
        target:set_sky({fog = {
          fog_distance = 2 + data.total_timer / data.duration * (data.range or 40),
          fog_start = 0.75,
          fog_color = "#000000"
        }})
      end
    end
    def.set_data(target, data)
  end
})

-- applies 15% of HP or 1 which ever is larger
local function apply_gas_damage(obj, pos)
  if obj:is_player() and
     obj:get_hp() > 0 and
     obj:get_properties().pointable
  then
    local hp = obj:get_hp()
    local props = obj:get_properties()
    local hp_delta = math.floor(props.hp_max * 15 / 100)
    local hp_damage = math.max(1, hp_delta)
    local new_hp = math.max(0, hp - math.floor(hp_damage))
    obj:set_hp(new_hp)
  elseif not obj:is_player() and obj:get_luaentity().mg_id ~= nil then
    local mob = obj:get_luaentity()
    local hp_delta = math.floor(mob.max_hp * 15 / 100)
    local hp_damage = math.max(1, hp_delta)
    if (mob.hp or -1) > 0 then
      mobkit.make_sound(mob,'hurt')
      mobkit.hurt(mob, hp_damage)
      if pos then
        mobkit.hq_runfrom_pos(mob, 10, pos)
      end
    end
  end
end

-- Using effects as a way to debounce gas damage
mg_oe.register_effect("gas_damage", {
  on_prestart = function(def, target, _duration, pos)
    local data = def.get_data(target)

    -- check if the effect is in progress
    if data.total_timer == 0 then
      apply_gas_damage(target, pos)
      -- apply the effect
      return true
    end
    -- don't apply the effect
    return false
  end
})

-- this is taken care of in the mg_combat and mg_mobs/utils.lua
-- if target is hit, then has 100% chance to hit
-- and 3x damage
-- if player is wielding a dagger, then 5x damage
mg_oe.register_effect("gas_paralysis", {
  icon = "mcl_potions_effect_slowness.png",
  default_data = {
    speed = 1
  },
  on_start = function(def, target, duration)
    if target:is_player() then
      player_monoids.speed:add_change(target, 0, "mg_oe:paralyzed")
      player_monoids.jump:add_change(target, 0, "mg_oe:paralyzed")
      local vel = target:get_velocity()
      target:add_velocity(vector.multiply(vel, -1))
    end
    -- for mobs
    local data = def.get_data(target)
    data.speed = 0
    -- starts the paralysis all over again
    data.duration = duration
    data.total_timer = 0
    def.set_data(target, data)
  end,
  on_clear = function(def, target)
    if target:is_player() then
      speed:del_change(target, "mg_oe:paralyzed")
      player_monoids.jump:del_change(target, "mg_oe:paralyzed")
    end
    -- for mobs
    local data = def.get_data(target)
    data.speed = 1
    def.set_data(target, data)
  end,
  on_step = function(def, target)
    add_spawner(target, "#5A6C81")
    local data = def.get_data(target)
    if not target:is_player() then
      local mob = target:get_luaentity()
      mob.speed = mob.max_speed * data.speed
    end
  end
})

local function apply_player_confused(target)
  local tries = 0
  while tries < 10 do
    tries = tries + 1
    local pos = target:get_pos()
    local random_yaw = math.random() * 2 * math.pi
    local dir = vector.multiply(
      core.yaw_to_dir(random_yaw),
      2
    )
    local target_pos = vector.add(
      pos,
      dir
    )
    local pos_good = true
    local cast = core.raycast(pos, target_pos, false, false)
    local thing = cast:next()
    while thing do
      if thing.type == "node" then
        local node = core.get_node(thing.intersection_point)
        local def = minetest.registered_nodes[node.name]
        -- A walkable node is a solid node
        if def and def.walkable then
          pos_good = false
          break
        end
      end
      thing = cast:next()
    end
    if pos_good then
      target:add_velocity(vector.multiply(dir, 5))
      return
    end
  end
end

local confused_particle = "mg_oe_confused.png"

mg_oe.register_effect("confusion", {
  icon = "mcl_potions_effect_nausea.png",
  default_data = {
    confused_timer = 0,
    did_move = false
  },
  on_start = function(def, target, duration)
    local data = def.get_data(target)

    -- reset duration and total timer
    data.duration = duration
    data.total_timer = 0
    data.confused_timer = 0
    def.set_data(target, data)
  end,
  on_step = function(def, target, dt)
    local data = def.get_data(target)
    data.confused_timer = data.confused_timer + dt
    add_custom_spawner(target, confused_particle)
    if target:is_player() then
      local vel = target:get_velocity()
      local sum = math.abs(vel.x) + math.abs(vel.y) + math.abs(vel.z)
      if sum > 0 then
        data.did_move = true
      end
      if data.confused_timer > 0.5 then
        if data.did_move then
          -- push player to random place 2 spaces away
          apply_player_confused(target)
        end
        -- reset timer and did move
        data.confused_timer = 0
        data.did_move = false
      end
      def.set_data(target, data)
    end
  end
})

-- can stack in time
-- doesn't apply to player
-- only need to check if mobs have it
local discordant_particle = "mg_oe_discordant.png"
mg_oe.register_effect("discordant", {
  on_start = function(def, target)
    -- doesn't apply to players
    if target:is_player() then
      local data = def.get_data(target)
      data.duration = 0
      data.total_timer = 0
      data.confused_timer = 0
      def.set_data(target, data)
    end
  end,
  on_step = function(_def, target)
    add_custom_spawner(target, discordant_particle)
  end,
  on_clear = function(_def, target)
    local mob = target:get_luaentity()
    -- clear out the high queue so mobs can reset
    -- their hunting
    if mob and mob.mg_id then
      mobkit.clear_queue_high(mob)
    end
  end,
})
