-- Maybe borrow the below code when play drinks a potion
-- core.sound_play("mcl_potions_drinking", {pos = pos, max_hear_distance = 6, gain = 1})


local permadeath = core.settings:get_bool("permadeath", true)

-- Updating max hp doesn't presist for some reason
minetest.register_on_joinplayer(function(player)
	local storage = {}
	local data = player:get_meta():get_string("mg_potions:data")
	if data ~= "" then
		storage = minetest.deserialize(data) or storage
	end
	if storage.max_hp then
    player:set_properties({
      hp_max = storage.max_hp,
    })
	end
end)

local function reset_max_hp(player)
  local hp = 30
  local storage = { max_hp = hp }
  player:get_meta():set_string("mg_potions:data", minetest.serialize(storage))
  player:set_properties({
    hp_max = hp
  })
  player:set_hp(hp)
end

local function reset_hp(player)
  if permadeath then
    reset_max_hp(player)
  end
end


-- after player dies set back to 30
core.register_on_respawnplayer(function(player)
  reset_hp(player)
end)

core.register_on_newplayer(function(player)
  reset_max_hp(player)
end)

local function increase_hp (itemstack, user)
  mg_oe.clear_effect('poison', user)
  mg_oe.clear_effect('weakness', user)
  local props = user:get_properties()
  local new_hp = math.floor(props.hp_max * 1.33)
  user:set_properties({
    hp_max = new_hp,
  })
  user:set_hp(new_hp)
  local storage = { max_hp = new_hp }
  user:get_meta():set_string("mg_potions:data", minetest.serialize(storage))
  local player_name = user:get_player_name()
  local message = "Your max HP is increased by 33% and your HP is completely restored."
  minetest.chat_send_player(player_name, message)
  itemstack:take_item(1)
  return itemstack
end

local function increase_strength (itemstack, user)
  mg_strength.increase(user)
  mg_oe.clear_effect('weakness', user)
  local player_str = mg_strength.get_strength_raw(user)
  local player_name = user:get_player_name()
  local message = "New found strength surges through your body.  Your strength is now " .. player_str .. "."
  minetest.chat_send_player(player_name, message)
  itemstack:take_item(1)
  return itemstack
end

minetest.register_craftitem("mg_potions:strength", {
  description = "A potion of strength - increase strength to wield better weapons",
  inventory_image = "pep_jumpplus.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Drinking this will make you stronger. You will be able to wield heavy weapons more effectively and wear heavier armor to your advantage.",
  on_use = function(itemstack, user, _pointed_thing)
    return increase_strength(itemstack, user)
  end,
  on_place = function(itemstack, user, _pointed_thing)
    return increase_strength(itemstack, user)
  end
})

minetest.register_craftitem("mg_potions:life", {
  description = "A potion of life - restore all health and increase max HP 30%",
  inventory_image = "pep_regen2.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Drinking this will instantly heal you and increase your max health.",
  on_use = function(itemstack, user, _pointed_thing)
    return increase_hp(itemstack, user)
  end,
  on_place = function(itemstack, user, _pointed_thing)
    return increase_hp(itemstack, user)
  end
})

if not table.unpack then table.unpack = unpack end

local function apply_effect(name, duration, ...)
  local args = {n = select("#", ...), ...}
  return function(itemstack, player)
    mg_oe.start_effect(name, player, duration, table.unpack(args, 1, args.n))
    itemstack:take_item(1)
    return itemstack
  end
end

minetest.register_craftitem("mg_potions:slowness", {
  description = "Slows the player down",
  inventory_image = "pep_regen2.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Drinking this will slow you down",
  on_use = apply_effect('slowness', 10),
  on_place = apply_effect('slowness', 10)
})

minetest.register_craftitem("mg_potions:speed", {
  description = "Potion of Speed",
  inventory_image = "pep_speedplus.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Drinking it will make you run faster for 30 seconds.",
  on_use = apply_effect('speed', 30),
  on_place = apply_effect('speed', 30)
})
core.register_alias("pep:speedplus", "mg_potions:speed")

minetest.register_craftitem("mg_potions:invisibility", {
  description = "Potion of Invisibility",
  inventory_image = "pep_invisibility.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Drinking it will reduce your stealth range to 1, making it very difficult for monsters to detect you.",
  on_use = apply_effect('invisibility', 75),
  on_place = apply_effect('invisibility', 75)
})
core.register_alias("pep:invisibility", "mg_potions:invisibility")

minetest.register_craftitem("mg_potions:levitation", {
  description = "Potion of Leviation",
  inventory_image = "pep_grav0.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "When you drink this potion, gravity stops affecting you, as if you were in space. The effect lasts for 20 seconds.",
  on_use = apply_effect('levitation', 20),
  on_place = apply_effect('levitation', 20)
})
core.register_alias("pep:grav0", "mg_potions:levitation")

minetest.register_craftitem("mg_potions:fire_immunity", {
  description = "Potion of Fire Immunity",
  inventory_image = "pep_fire_immunity.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Drinking this potion will make you immune to damage from lava and fire for 150 seconds",
  on_use = apply_effect('fire_immunity', 150),
  on_place = apply_effect('fire_immunity', 150)
})
core.register_alias("pep:fire_immunity", "mg_potions:fire_immunity")

minetest.register_craftitem("mg_potions:darkness", {
  description = "Potion of Darkness",
  inventory_image = "pep_invisibility.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Drinking this will reduce your sight range.",
  on_use = apply_effect('darkness', 10, 39),
  on_place = apply_effect('darkness', 10, 39)
})

minetest.register_craftitem("mg_potions:weakness", {
  description = "Potion of Weakness",
  inventory_image = "pep_speedplus.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Drinking it will make you weak for 30 seconds.",
  on_use = apply_effect('weakness', 30),
  on_place = apply_effect('weakness', 30)
})

minetest.register_craftitem("mg_potions:poison", {
  description = "Potion of Poison",
  inventory_image = "pep_speedplus.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Poisoned for 5 seconds",
  on_use = apply_effect('poison',5, 1),
  on_place = apply_effect('poison', 5, 1)
})

minetest.register_craftitem("mg_potions:paralysis", {
  description = "Potion of Paralysis",
  inventory_image = "pep_speedplus.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Paralysis ",
  on_use = apply_effect('gas_paralysis', 10),
  on_place = apply_effect('gas_paralysis', 10)
})




dofile(core.get_modpath("mg_potions") .. "/throwable.lua")

mg_potions = {}
mg_potions.reset_hp = reset_hp
