minetest.register_craftitem("mg_scrolls:shattering", {
  description = "A scroll of shattering",
  inventory_image = "spelltest_spell_blue.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Reading this scroll will turn the rock around the player into purple crystal that dispates over time, creating air where rock used to be.",
  on_use = function(itemstack, user, _pointed_thing)
    itemstack:take_item(1)
    local pos = user:getpos()
    mg_effects.shattering({pos = pos, radius = 5})
    return itemstack
  end
})

minetest.register_craftitem("mg_scrolls:negation", {
  description = "A scroll of negation",
  inventory_image = "spelltest_spell_black.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Reading this scroll will unleash a torret of anti-magic through the level.  It will negate any effects on you and any on nearby monsters.",
  on_use = function(itemstack, user, _pointed_thing)
    itemstack:take_item(1)
    local pos = user:getpos()
    mg_effects.negate({pos = pos, radius = 30})
    return itemstack
  end
})

minetest.register_craftitem("mg_scrolls:discord", {
  description = "A scroll of discord",
  inventory_image = "voxeldungeon_item_scroll_berkanan.png",
  stack_max = 1,
  range = 1.5,
  mg_help = " 	Reading this scroll will unleash a powerful blast of mind magic. Any creatures within line of sight will turn against their companions and attack indiscriminately for 30 seconds.",
  on_use = function(itemstack, user, _pointed_thing)
    itemstack:take_item(1)
    local pos = user:getpos()
    mg_effects.apply_discord({pos = pos, radius = 30})
    return itemstack
  end
})


minetest.register_craftitem("mg_scrolls:recharging", {
  description = "A scroll of recharging (recharges staves and charms)",
  mg_help = "Reading this scroll will fully recharge all your staves and charms",
  inventory_image = "spelltest_spell_yellow.png",
  stack_max = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    itemstack:take_item(1)
    mg_bolts.recharge_staves(user)
    mg_bolts.recharge_charms(user)
    return itemstack
  end
})

minetest.register_craftitem("mg_scrolls:teleport", {
  description = "A scroll of teleportation",
  mg_help = "Reading this scroll will teleport you to a random place in the level of the current depth.  Great for quick escapes!",
  inventory_image = "voxeldungeon_item_scroll_gyfu.png",
  stack_max = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    itemstack:take_item(1)
    mg_effects.teleport(user)
    return itemstack
  end
})

local function update_desc(stack)
  local name = stack:get_name()
  if string.find(name, "mg_tools") then
    return mg_tools.update_desc(stack)
  elseif string.find(name, "mg_armor") then
    mg_armor.update_desc(stack)
  elseif string.find(name, "mg_rings") then
    mg_rings.update_desc(stack)
  end
end

local function check_inv(player, listname)
  local count = 0
  local inv = player:get_inventory()
  local size = inv:get_size(listname)
  for i=1, size do
    local stack = inv:get_stack(listname, i)
    local meta = stack:get_meta()
    local magic_polarity = meta:get_int("magic_polarity", 0)
    if magic_polarity < 0 then
      meta:set_int("magic_polarity", 0)
      update_desc(stack)
      inv:set_stack(listname, i, stack)
      count = count + 1
    end
  end
  return count
end

minetest.register_craftitem("mg_scrolls:remove_curse", {
  description = "Scroll of Remove Curse",
  mg_help = "Reading this scroll will remove the curse off any item in your inventory or you are wearing.",
  inventory_image = "voxeldungeon_item_scroll_mannaz.png",
  stack_max = 1,
  range = 1.5,
  on_use = function(itemstack, player, _pointed_thing)
    local username = player:get_player_name()
    itemstack:take_item(1)

    local count = 0

    -- go through armor or rings player is wearing
    local _, inv = armor:get_valid_player(player, "[validate_armor_inventory]")
    for i = 1, 6 do
      local stack = inv:get_stack("armor", i)
      if stack:get_count() > 0 then
        local meta = stack:get_meta()
        local magic_polarity = meta:get_int("magic_polarity", 0)
        if magic_polarity < 0 then
          meta:set_int("magic_polarity", 0)
          update_desc(stack)
          inv:set_stack("armor", i, stack)
          count = count + 1
        end
      end
    end

    -- Go through players inventory, main and the info box
    count = count + check_inv(player, "main")
    count = count + check_inv(player, "info")

    if count > 0 then
      core.chat_send_player(username, "You feel a malevolent energy leave you.")
    else
      core.chat_send_player(username, "You read the scroll, but nothing happens.")
    end

    return itemstack
  end
})

local mod_path = minetest.get_modpath("mg_scrolls")
dofile(mod_path .. "/item_enhancement.lua")
