local stealth_cache = {}

-- set stealth prop
-- invisible
-- armor_penalty
-- ring_bonus
-- alarm_penalty
local function set_stealth_prop(player_name, prop, value)
  local player_stealth_cache = stealth_cache[player_name] or {}
  player_stealth_cache[prop] = value
  stealth_cache[player_name] = player_stealth_cache
end

local get_invisible = function(player)
  if not player:is_player() then
    return 0
  end

  local meta = player:get_meta()
  local invisible = meta:get_int("mg_invisible") or 0
  set_stealth_prop(player:get_player_name(), 'invisible', invisible)
  return invisible
end

local set_invisible = function(player, amount)
  if not player:is_player() then
    return
  end

  local meta = player:get_meta()
  meta:set_int("mg_invisible", amount)

  set_stealth_prop(player:get_player_name(), 'invisible', amount)
end

local function get_stealth(player)
  -- if this is a mob then return 7
  if not player:is_player() then
    return 7
  end
  local player_name = player:get_player_name()
  local s = stealth_cache[player_name] or {}

  -- from invisibility charm or potion
  local invisible = s.invisible or get_invisible(player)

  if invisible and invisible > 0 then
    return 1
  end

  local armor_penalty = s.armor_penalty or 0
  local ring_bonus = s.ring_bonus or 0
  -- TODO This would be from an alarm trap - I don't have one yet
  local alarm_penalty = s.alarm_penalty or 0

  local stealth = 7 + armor_penalty - ring_bonus + alarm_penalty

  if stealth < 2 then
    stealth = 2
  end

  local v = player:get_velocity()
  local vel_abs = v.x*v.x + v.y*v.y + v.z*v.z

  -- still
  if vel_abs <= 0.1 then
    stealth = math.ceil(stealth * 0.5 )
  -- sneaking
  elseif vel_abs <= 2 then
    stealth = math.ceil(stealth * 0.75 )
  end

  return stealth
end

mg_stealth = {}
mg_stealth.get_stealth = get_stealth
mg_stealth.get_invisible = get_invisible
mg_stealth.set_invisible = set_invisible
mg_stealth.set_stealth_prop = set_stealth_prop
