-- brogue marks the grid spaces around the stairs as in field of view
-- so that monsters don't spawn there
-- i need to do something similar

local coordinatesAreInMap = mg_arch.coordinatesAreInMap
local cellHasTerrainFlag = mg_arch.cellHasTerrainFlag
local hasAnyFlags = mg_arch.hasAnyFlags

--local function printTable (table)
  --print(json.encode(table))
--end



local function betweenOctant1andN(x, y, x0, y0, n)
  local x1 = x
  local y1 = y
  local dx = x1 - x0
  local dy = y1 - y0
  if n == 1 then
    return x, y
  elseif n == 2 then
    return x, y0 - dy
  elseif n == 5 then
    return x0 - dx, y0 - dy
  elseif n == 6 then
    return x0 - dx, y
  elseif n == 8 then
    return x0 - dy, y0 - dx
  elseif n == 3 then
    return x0 - dy, y0 + dx
  elseif n == 7 then
    return x0 + dy, y0 - dx
  elseif n == 4 then
    return x0 + dy, y0 + dx
  end
end

local LOS_SLOPE_GRANULARITY = 32768
--local LOS_SLOPE_GRANULARITY = 0.5

local function scanOctantFOV(
  pmap, grid, xLoc, yLoc, octant, maxRadius,
  columnsRightFromOrigin, startSlope, endSlope,
  forbiddenTerrain, forbiddenFlags,
  cautiousOnWalls
)
  local loc = {x = xLoc, y = yLoc}
  if columnsRightFromOrigin >= maxRadius then
    return
  end

  local newStartSlope = startSlope
  local a = ((LOS_SLOPE_GRANULARITY / -2 + 1) + startSlope * columnsRightFromOrigin) / LOS_SLOPE_GRANULARITY
  local b = ((LOS_SLOPE_GRANULARITY / -2 + 1) + endSlope * columnsRightFromOrigin) / LOS_SLOPE_GRANULARITY
  local iStart = math.min(a, b)
  local iEnd = math.max(a, b)

  if (columnsRightFromOrigin*columnsRightFromOrigin + iEnd*iEnd) >= maxRadius*maxRadius then
    return
  end

  if (columnsRightFromOrigin*columnsRightFromOrigin + iStart*iStart) >= maxRadius*maxRadius then
    iStart = -1* math.sqrt(maxRadius*maxRadius - columnsRightFromOrigin*columnsRightFromOrigin)
  end

  local x = math.ceil(loc.x  + columnsRightFromOrigin)
  local y = math.ceil(loc.y + iStart)
  x, y = betweenOctant1andN(x, y, loc.x, loc.y, octant)

  local currentlyLit = coordinatesAreInMap(x, y) and
    not (cellHasTerrainFlag(pmap, x, y, forbiddenTerrain)
         or hasAnyFlags(pmap[x][y].flags, forbiddenFlags))

  for i=iStart, iEnd do
    x = math.ceil(loc.x + columnsRightFromOrigin)
    y = math.ceil(loc.y + i)
    x, y = betweenOctant1andN(x, y, loc.x, loc.y, octant)
    if coordinatesAreInMap(x, y) then
      local cellObstructed = cellHasTerrainFlag(pmap, x, y, forbiddenTerrain) or hasAnyFlags(pmap[x][y].flags, forbiddenFlags)
      grid[x][y] = 1
      if not cellObstructed and not currentlyLit then
        newStartSlope = (LOS_SLOPE_GRANULARITY * i - LOS_SLOPE_GRANULARITY / 2) / (columnsRightFromOrigin * 2 + 1) * 2
        currentlyLit = true
      elseif cellObstructed and currentlyLit then
        local newEndSlope = (LOS_SLOPE_GRANULARITY * i - LOS_SLOPE_GRANULARITY / 2) / (columnsRightFromOrigin * 2 - 1) * 2
        if newStartSlope <= newEndSlope then
          scanOctantFOV(pmap, grid, loc.x, loc.y, octant, maxRadius, columnsRightFromOrigin + 1, newStartSlope, newEndSlope, forbiddenTerrain, forbiddenFlags, cautiousOnWalls)
        end
        currentlyLit = false
      end
    end
  end
  if currentlyLit then
    local newEndSlope = endSlope
    if newStartSlope <= newEndSlope then
        scanOctantFOV(pmap, grid, loc.x, loc.y, octant, maxRadius, columnsRightFromOrigin + 1, newStartSlope, newEndSlope, forbiddenTerrain, forbiddenFlags, cautiousOnWalls)
    end
  end
end

local function getFOVMask(pmap, grid, xLoc, yLoc, maxRadius, forbiddenTerrain, forbiddenFlags, cautiousOnWalls)
  for i=1, 8 do
    scanOctantFOV(
      pmap, grid, xLoc, yLoc, i, maxRadius,
      1, LOS_SLOPE_GRANULARITY * -1, 0,
      forbiddenTerrain, forbiddenFlags,
      cautiousOnWalls
    )
  end
end

local tf = mg_arch.terrainFlags
local function mark_upstairs_fov(pmap, xLoc, yLoc)
  local fovGrid = mg_arch.allocGrid()
  mg_arch.getFOVMask(pmap, fovGrid, xLoc, yLoc, mg_arch.DCOLS, tf.T_OBSTRUCTS_VISION, {}, false)

  for i = 1, mg_arch.DCOLS do
    for j = 1, mg_arch.DROWS do
      if fovGrid[i][j] > 0 then
        pmap[i][j].flags.in_field_of_view = 1
      end
    end
  end
end

local function clear_fov(pmap)
  for i = 1, mg_arch.DCOLS do
    for j = 1, mg_arch.DROWS do
      pmap[i][j].flags.in_field_of_view = nil
    end
  end
end

mg_arch.getFOVMask = getFOVMask
mg_arch.mark_upstairs_fov = mark_upstairs_fov
mg_arch.clear_fov = clear_fov
