-- TODO: want to rename this to mg_dungeon
-- This is more of a utility mod in pure lua,
-- it does not interact with luanti core
mg_arch = {}


local mod_path = minetest.get_modpath("mg_arch")

dofile(mod_path.."/globals.lua")
dofile(mod_path.."/grid.lua")
dofile(mod_path.."/dijkstra.lua")
dofile(mod_path.."/arch.lua")
dofile(mod_path.."/items.lua")
dofile(mod_path.."/monsters.lua")
dofile(mod_path.."/fov.lua")

core.register_async_dofile(mod_path .. "/globals.lua")
core.register_async_dofile(mod_path .. "/grid.lua")
core.register_async_dofile(mod_path .. "/dijkstra.lua")
core.register_async_dofile(mod_path .. "/arch.lua")
core.register_async_dofile(mod_path .. "/items.lua")
core.register_async_dofile(mod_path .. "/monsters.lua")
core.register_async_dofile(mod_path .. "/fov.lua")


local default_dungeon = {
  seed = 0,
  MAX_LEVELS = 20,
  AMULET_LEVEL = 13,
  NUMBER_GENERATED_LEVELS = 0,
  worldData = {},
  levels = {},
}

mg_arch.default_dungeon = default_dungeon

mg_arch.dungeon = table.copy(default_dungeon)

local pmap_cache = {}

function mg_arch.save_pmap(depth, pmap)
  pmap_cache[depth] = pmap
  print('save pmap of depth '..depth..' to file')
  local filename = core.get_worldpath().."/pmap-"..depth..".txt"
  print('save pmap of depth '..depth..' to file ' .. filename)
  local file = io.open(filename, "w")
  if file then
    file:write(core.serialize(pmap))
    file:close()
  end
end

function mg_arch.load_pmap(depth)
  local pmap = pmap_cache[depth]
  if pmap then
    print('found pmap in cache - returning it')
    return pmap
  end
  local filename = core.get_worldpath().."/pmap-"..depth..".txt"
  print('not in cache, load file for '..depth..' from file ' .. filename)
  local file = io.open(filename, "r")
  if file then
    print('found saved pmap file, loading it')
    local t = core.deserialize(file:read("*all"))
    if type(t) == "table" then
      -- actually cache it
      pmap_cache[depth] = t
      return t
    end
  end
  print('no saved pmap found')
  return
end

function mg_arch.save_dungeon(d)
  print('save dungeon to file')
  local file = io.open(minetest.get_worldpath().."/dungeon.txt", "w")
  if file then
    file:write(core.serialize(d))
    file:close()
  end
end

function mg_arch.load_dungeon()
  local file = io.open(minetest.get_worldpath().."/dungeon.txt", "r")
  if file then
    print('found saved level file, loading it')
    local table = core.deserialize(file:read("*all"))
    if type(table) == "table" then
      print('found table in file - ' .. (table.seed or ""))
      return table
    end
  end
  print('no saved dungeon found, use default dungeon')
  return table.copy(default_dungeon)
end

core.register_on_mods_loaded(function()
  print('load up saved levels if any')
  mg_arch.dungeon = mg_arch.load_dungeon()
end)
