
core.register_on_player_receive_fields(function(player, _formname, fields)
  if not (fields.respawn and fields.dungeon_seed) then return end

  if fields.dungeon_seed then
    local playername = player:get_player_name()
    core.close_formspec(playername, "")
    core.chat_send_player(playername, "Respawning all players" .. fields.dungeon_seed)
    mg_game.dungeon_seed = tonumber(fields.dungeon_seed)
    for _, next_player in ipairs(core.get_connected_players()) do
      next_player:respawn()
    end
  end
end)

sfinv.register_page("mg_game:settings", {
	title = "Settings",
	get = function(_self, player, context)
    local pn = player:get_player_name()
		return sfinv.make_formspec(player, context, [[
      label[0,0.5;Respawn, regenerate the dungeon and restart the game.]
      label[0,0.8;Optionally provide a seed. It must be a number or blank.]
      field[0.3,2;4,1;dungeon_seed;Dungeon Seed:;]
      button[0,3;2,1;respawn;Restart]"
			]], false)
	end
})
