local esc = core.formspec_escape

-- Generic item help function
local function get_item_help(itemname, show_image)

  local def = core.registered_items[itemname]

  if not def then return "" end

  local help = ""

  if def.mg_help and def.mg_help ~= "" then
    local img = "<img name=".. def.inventory_image .." float=left width=64 height=64> "
    if show_image == false then
      img = ""
    end
    help = img .. "<b>" .. def.description .. ".</b> " .. def.mg_help
  end

  return help
end

local function makeguide()
  local weapons = mg_arch.item_api.getItemsByCategory("weapon")

  local weapons_guide = [[
<big><b>Weapons</b></big>
Weapons are used to hit monsters. Some weapons will do more damage than others, but those weapons will require you to be stronger to use. If you do use them without the required strength, you may find your hits missing monsters more often than not. You can lower the strength requirement of a weapon by enchanting it. Pay attention to the messages the game sends you when you first wield a weapon, it'll tell the strength requirement of the weapon. If you spam the weapon and don't wait for the weapon to reset, you will miss monsters more often than not as well. Some weapons have a longer hit range. These are useful so you don't have to get up so close to the monsters to fight them. Weapons spawn in the dungeon with positive, negative or no enchantments. These are hidden from you. You can identify what they are by either killing 20 monsters with the weapon or using a scroll of identification on the weapon. Watch out for monsters that will degrade your weapons if you hit them. A scroll of protect weapon will protect your weapon from this fate.
]]

  for _, item in ipairs(weapons) do
    weapons_guide = weapons_guide .. mg_tools.get_weapon_help(item.node_name) .. "\n\n"
  end

  local armor_guide = [[

<big><b>Armor</b></big>
Good armor reduces the chance that a monster will hit you. Higher armor class is better. Heavier armor requires more strength. You can also lower the strength requirement of armor by enchanting it. Better protection comes at a cost. It's noisy and increases the range at which monsters notice you - your stealth stat is higher. Armor spawns in the dungeon with positive, negative or no enchantments. These will be hidden as well. If you wear your armor for 500 seconds or more, you will become familiar with it and know what it's intrinsic enchantments are. There are monsters that can degrade your armor if they hit you. A scroll of protect armor will protect your armor from this fate.
]]

  local armor = mg_arch.item_api.getItemsByCategory("armor")

  for _, item in ipairs(armor) do
    armor_guide = armor_guide .. mg_armor.get_armor_help(item.node_name) .. "\n\n"
  end


  -- Staves help
  local staves_guide = [[

<big><b>Staves</b></big>
Staves are powerful magical items that shoot magical bolts. Staves spawn with 2-5 charges and recharge over time. Enchanting a staff will increase it's maximum charges, increase the effect of the bolt, increase the range of the staff and decrease the time it takes to recharge. 
]]
  local staves = mg_arch.item_api.getItemsByCategory("staff")
  for _, item in ipairs(staves) do
    staves_guide = staves_guide .. mg_bolts.get_staff_help(item.node_name) .. "\n\n"
  end

  -- Charms guide
  local charms_guide = [[

<big><b>Charms</b></big>
Charms are like staves in which they are rechargeable, but they only have one charge and they effect you or your environment in different ways instead of shooting a bolt.  Enchanting a charm will increase the duration and potency of its magical effect and decrease the time it takes to recharge.
]]
  local charms = mg_arch.item_api.getItemsByCategory("charm")
  for _, item in ipairs(charms) do
    charms_guide = charms_guide .. mg_bolts.get_staff_help(item.node_name) .. "\n\n"
  end


  -- Rings Guide
  local rings_guide = [[

<big><b>Rings</b></big>
Rings increase some internal effect on the player.  Enchanting the ring will increase the potency of its effect. Only one ring can be worn at a time. Rings can spawn with positive or negative enchantments. Negative enchantments will make worsen the effect of the ring.
]]
  local rings = mg_arch.item_api.getItemsByCategory("ring")
  for _, item in ipairs(rings) do
    rings_guide = rings_guide .. mg_rings.get_ring_help(item.node_name) .. "\n\n"
  end

  -- Scrolls Guide
  local scrolls_guide = [[

<big><b>Scrolls</b></big>
Scrolls are one time use items that have some magical effect.  They cannot be enchanted.
]]

  local scrolls = mg_arch.item_api.getItemsByCategory("scroll")
  for _, item in ipairs(scrolls) do
    scrolls_guide = scrolls_guide .. get_item_help(item.node_name, true) .. "\n\n"
  end

  -- Potions Guide
  local potions_guide = [[

<big><b>Potions</b></big>
Potions are one use item that can be drunk or thrown. Throwable potions will have some negative impact on when thrown. They cannot be enchanted.
]]

  local potions = mg_arch.item_api.getItemsByCategory("potion")
  for _, item in ipairs(potions) do
    potions_guide = potions_guide .. get_item_help(item.node_name, true) .. "\n\n"
  end




  local guide = [[
hypertext[0.5,0;7,11;guide_text;
<big><b>Getting Started</b></big>
 You're on a quest to retrieve the Crystal of Yendor, rumored to be somewhere in depth 13 of the dungeons. To win, find it, bring it back up to the surface, and place it on the pedestal.
 Along the way, collect as much gold as possible.  Gold is your high score. Beware! The dungeon and its inhabitants do not take kindly to intruders. There will be traps you must avoid and monsters to sneak around, to fight, or to run away from.  As you explore the dungeon, there will be many chests containing items to help you on your way to retrieve the fabled crystal.
 If you die on your quest, you will lose any items you find, your stats will reset, and you'll need to start again at the top. The dungeon itself will change its shape, and you will need to explore it anew.

<big><b>Items Overview</b></big>
In the chests you will find weapons, armor, staves, wands, charms, rings, potions, and scrolls. There are three very important items you especially need to be on the look out for:
  - The <b>potion of life</b> will permanently update your max health and fill it to the top.
  - The <b>potion of strength</b> will make you stronger. You will be able to wield heavy weapons more effectively and wear heavier armor to your advantage.
  - The <b>scroll of enchantment</b> can be used to permanently upgrade weapons, armor, staves, wands, charms or rings. You pick what you want to upgrade.
You build your character through items.  There are no player classes or experience points.  If you want to play as a warrior, find a weapon and put most of your enchancements in it.  If you want to play as a wizard, find a staff, charm or rings and put your enchantments in them.  You need to make the best of what you find on your runs.
You need to find potions of life and potions of strength to "level" up your character.  There are no experience points and you don't level up through experience.

<big><b>Stats Overview</b></big>
At the bottom of the screen you can see your character's stats. There's Satiation, Health, Stealth, AC, Str, Depth, Dmg, Acc and Breath.
<b>Satiation:</b> This is how hungry you are. Eating ration of food will increase your satiation by 20 points and an apple 10. Once your satiation is 2 or below, you start losing health points.
<b>Health</b> This is how much health you have. When monsters successfully hit you, your health goes down. When you health is 0 your character is dead and you need to restart your quest with a new character.
<b>Stealth</b> Monster need to be in the radius of your stealth range to have a chance to notice you. Each second monsters are within your stealth range, they have a 49 percent chance to notice you. If you hit a monster, they'll notice you right away and attack you. Not moving will cut your stealth range in half. The radius is in blocks. Heavier armor will increase your stealth range. A ring of stealth will reduce your stealth range. When you are invisible your stealth range is 1. If you are not invisible the lowest your stealth range can be is 2.
<b>AC</b> This is your armor class. Higher is better. A higher armor class will reduce the chance that a monster will land a hit on you. This stat is effected by the current armor you are wearing.
<b>Str</b> This is your strength. It can only go up by drinking a potion of strength. There are certain monsters that can temporarily weaken you when they hit you. Drinking a potion of strength or life will clear any weakness the player has.
<b>Depth</b> This is the dungeon level you are on. The crystal is on level 13. However, there are deeper levels than 13. If you desire an extra challenge, try to go deeper to collect more gold than a previous successful run. Beware, there are more fearsome monsters under depth 13 and it can get harder to see the lower you go.
<b>Dmg</b> This is the average damage the weapon you are wielding will do to a monster when you hit it.
<b>Acc</b> This is the accuracy at which you will hit a monster with the weapon you are wielding. If you are wielding a weapon with a higher strength requirement than what you current have, it will decrease your accuracy. Monsters have a defense stat which get applied against your accuracy which can make some of them hard to hit than it would appear.

]] .. weapons_guide .. armor_guide .. staves_guide .. charms_guide .. rings_guide .. scrolls_guide .. potions_guide .. "]"



  return guide
end

sfinv.register_page("mg_help:help", {
    title = "Help",
    get = function(_, player, context)
        mg_armor.get_armor_help("mg_armor:torso_cloth")
        return sfinv.make_formspec(player, context, makeguide(), false)
    end
})


-- Override the crafting page to show help for that item
-- Show the basic help, and stats of an item at players current strength 
-- and items current enchantment

local all_info = {}
local default = 'Place an item here to learn more about it.'

sfinv.override_page("sfinv:crafting", {
	title = "Inventory",
	get = function(self, player, context)
    local pn = player:get_player_name()
    local info = all_info[pn] or default
		return sfinv.make_formspec(player, context, [[
				list[current_player;info;0,0.5;1,1;]
        hypertext[1.25,0.5;7,5;item_help_text;]] .. info .. [[]
				listring[current_player;main]
				listring[current_player;info]
			]], true)
	end
})

core.register_on_joinplayer(function(player)
  local pn = player:get_player_name()
  local inv = core.get_inventory({type = 'player', name = pn})
  inv:set_size('info', 1)
end)

local function get_inv_help(item, player)
  local name = item:get_name()
  if string.find(name, "mg_tools") then
    return mg_tools.get_weapon_stats_desc(item, player)
  elseif string.find(name, "mg_armor") then
    return mg_armor.get_armor_help_stats(item, player)
  elseif string.find(name, "staff") then
    return mg_bolts.get_staff_help_stats(item, player)
  elseif string.find(name, "wand") then
    return mg_bolts.get_wand_help_stats(item)
  elseif string.find(name, "charm") then
    return mg_bolts.get_charm_help_stats(item)
  elseif string.find(name, "mg_rings:") then
    return mg_rings.get_ring_help_stats(item, player)
  end
  -- rings
  return get_item_help(name, false)
end

local form_refresh_job = nil

local function inv_timer(pn)
  local player = core.get_player_by_name(pn)
  local inv = player:get_inventory()
  local stack = inv:get_stack('info', 1)
  all_info[pn] = get_inv_help(stack, player)
  sfinv.set_player_inventory_formspec(player)
  form_refresh_job = core.after(1, function()
    inv_timer(pn)
  end)
end

core.register_on_player_inventory_action(function(player, action, inventory, inventory_info)
  local pn = player:get_player_name()
  if action == 'move' and inventory_info.to_list == 'info' then
    inv_timer(pn)
  elseif action == 'move' and inventory_info.from_list == 'info' then
    if form_refresh_job ~= nil then
      form_refresh_job:cancel()
    end
    local stack = inventory:get_stack('info', 1)
    local stack_name = stack:get_name()
    if stack_name == '' then
      all_info[pn] = default
      sfinv.set_player_inventory_formspec(player)
    end
  end
end)
