minetest.register_entity("mg_mobs:lich",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
    visual = "mesh",
    mesh = "mg_mobs_armor_character.b3d",
    textures = {
      "lottmobs_witch_king.png",
      "3d_armor_trans.png",
      "3d_armor_trans.png",
      "blank.png"
    },
    visual_size = {x = 1, y = 1},
    static_save = true,
    makes_footstep_sound = true,
  },
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.4,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 20,
  lung_capacity = 10,			-- seconds

  max_hp = 35,
  regen=0,
  defense = 120,
  accuracy = 160,
  attack={range=1.5,damage_groups={fleshy=2, fleshy_max=6}},
  sounds = {
    warn='mobs_mc_pillager_grunt1',
    hurt = 'mobs_mc_pillager_ow1',
  },
  animation = {
    run={range={x=168,y=187},speed=60,loop=true},
    walk={range={x=168,y=187},speed=30,loop=true},
    stand={range={x=0,y=79},speed=30,loop=true},
  },

  bolts = {
    "fire_bolt",
  },
  behaviors = {
    maintains_distance = 1,
  },
  abilities = {
    cast_summon = 1,
    avoids_corridors = 1,
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch = mg_mobs.handle_on_punch,
  on_death = mg_mobs.on_death,
})

mg_mobs.register_egg("mg_mobs:lich", "Lich", 1);

minetest.register_entity("mg_mobs:phylactery",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.2, -0.01, -0.2, 0.2, 0.29, 0.2},
    visual = "mesh",
    mesh = "mobs_mc_endermite.b3d",
    textures = {
      "mobs_mc_endermite.png",
    },
    visual_size = {x = 1, y = 1},
    static_save = true,
    makes_footstep_sound = true,
  },
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.4,
  jump_height = 1.26,
  view_range = 20,
  lung_capacity = 10,			-- seconds

  max_speed = 0,
  max_hp = 35,
  regen=0,
  defense = 0,
  accuracy = 0,
  attack={range=1.5,damage_groups={fleshy=2, fleshy_max=6}},
  sounds = {
    warn = 'enderpearl_teleport',
    hurt = 'mg_traps_click',
  },
  animation = {
    run={range={x=168,y=187},speed=60,loop=true},
    walk={range={x=168,y=187},speed=30,loop=true},
    stand={range={x=0,y=79},speed=30,loop=true},
  },

  bolts = { },
  behaviors = {
    dies_if_negated = 1,
    cast_spells_slowly = 1,
  },
  abilities = {
    cast_summon = 1,
    enters_summon = 1,
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
  on_death = mg_mobs.on_death,
})

mg_mobs.register_egg("mg_mobs:phylactery", "Phylactery", 1);
