minetest.register_entity("mg_mobs:pixie",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.2, 0.2, -0.2, 0.2, 1.0, 0.2},  --bat
    visual = "mesh",
    mesh = "mobs_mc_vex.b3d",
    textures = {
      "mobs_mc_vex.png"
    },
    visual_size = {x=1.25, y=1.25},
    static_save = true,
    makes_footstep_sound = true,
  },
	on_step = mobkit.stepfunc,	-- required
	on_activate = mobkit.actfunc,		-- required
	get_staticdata = mobkit.statfunc,
  physics = mg_mobs.fly_physics,
	springiness=0,
	buoyancy = 0.9,
	max_speed = 4,
	jump_height = 1.26,
	view_range = 20,
	lung_capacity = 10,			-- seconds
	max_hp = 10,
  regen=20,
  defense = 120,
  accuracy = 100,
	attack={range=1,damage_groups={fleshy=1, fleshy_max=3}},
	sounds = {
		death = "mobs_mc_vex_death",
		hurt = "mobs_mc_vex_hurt",
  },

	animation = {
    fly={range={x=0,y=40},speed=25,loop=true},
    walk={range={x=0,y=40},speed=25,loop=true},
    stand={range={x=40,y=80},speed=25,loop=true},
	},

  bolts = {
    "spark",
    "negation",
    "slow"
  },

  behaviors = {
    flies = 1,
    flits = 1,
    maintains_distance = 1,
  },

  abilities = {
  },

	brainfunc = mg_mobs.mg_brain,
	on_punch = mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:pixie", "Pixie", 1);
