local startY = 0

local mod_path = core.get_modpath("mg_mobs")
local ai_tools = dofile(mod_path.."/ai_tools.lua")

local function queue_message (self, publisher, message, data)
  local messages = self.mg_messages or {}
  local message_obj = {
    publisher = publisher, message = message, data = data
  }
  table.insert(messages, message_obj)
  self.mg_messages = messages
end

local function spawn(pos, monster, id)
  local obj = core.add_entity(pos, 'mg_mobs:'..monster)
  local mob = obj:get_luaentity()
  mob.mg_id = id or ai_tools.uuid()
  return obj
end


local function spawnMonsters(depth, monsters)
  local baseY = -11 * (depth - 1) + startY + 6
  local mobs = {}

  for _,monst in pairs(monsters) do
    local pos = {x=monst.x, y = baseY, z = monst.y}
    if monst.monsterType then
      -- if the monster spawns in a wall, then turn wall nodes into air
      local message = 'spawn monster at depth '.. depth .. ' of type ' .. monst.monsterType
      local obj = spawn(pos, monst.monsterType, monst.monsterId)
      local mob = obj:get_luaentity()
      table.insert(mobs, mob)
      mob.leader_id = monst.leaderId
      message = message .. ' added entity - id ' .. mob.mg_id .. ', leader id: ' .. mob.leader_id
      print(message)
      if mob.behaviors and mob.behaviors.in_wall then
        -- turn nodes it spawned into air
        -- and one above it
        core.set_node(pos, {name = "air"})
        core.set_node({x=pos.x, y = pos.y+1, z=pos.z}, {name = "air"})
      end
    end
  end
  return mobs
end

local function hq_clear(self)
  local timer = 2
  local start = true

  self.object:set_properties({
    collide_with_objects = false,
    textures = {"blank.png"}
  })

  self.hp = 0
  self.dead = true

  local func = function(self)
    if start then
      mobkit.lq_fallover(self)
      self.logic = function(self) end	-- brain dead as well
      start=false
    end
    timer = timer-self.dtime
    if timer < 0 then self.object:remove() end
  end
  mobkit.queue_high(self,func,100)
end

-- This is dependant on the level
local function summon_horde(self, max_count, target)
  max_count = max_count or 1
  -- see if current summoned members are less than 5 then can summon more

  local minion_count = 0
	for _,obj in ipairs(self.nearby_objects) do
    local mob = obj:get_luaentity()
    if mob and mob.leader_id == self.mg_id then
      minion_count = minion_count + 1
    end
  end

  print('current minion count: ' .. minion_count)

  if minion_count >= max_count then
    print('no summon, too many minions')
    return false
  end

  if self.abilities.enters_summon and math.random(0, 6) > 0 then
    print('no summon, bad dice')
    return false
  end

  if not self.abilities.enters_summon and
     minion_count > 0 and
     math.random(0, minion_count * minion_count) > 0
  then
    print('no summon, bad dice')
    return false
  end

  print('summon minions!')


  -- there's some logic that needs to be applies about how many
  -- minions are currently summoned and if monster can summon more
  local pos = mobkit.get_stand_pos(self)
  local depth = math.floor((pos.y - startY - 10) / (-11) + 1)
  local pmap = mg_arch.load_pmap(depth)

  local summoner = {
    monsterId = self.mg_id or ai_tools.uuid(),
    name = self.name:gsub("mg_mobs:", ""),
    x = math.floor(pos.x + 0.5),
    y = math.floor(pos.z + 0.5),
  }
  self.mg_id = summoner.monsterId

  -- weird dependency here
  -- this means casts can only happen in dungeon
  -- and I'd like to fix that
  local minions = mg_arch.monsters.summon_minions(pmap, summoner)

  if #minions > 0 then
    local def = core.registered_entities["mg_mobs:" .. minions[1].monsterType]
    local mob_flies = def.behaviors and def.behaviors.flies
    -- overwrite locations for minions
    local locations = ai_tools.find_loc(
      pos,
      1,5,
      not mob_flies,
      #minions
    )
    for i, minion in ipairs(minions) do
      if locations[i] then
        minion.x = locations[i].x
        minion.y = locations[i].z
      end
    end
  end

  local mobs = spawnMonsters(depth, minions)
  mobkit.make_sound(self,'warn')

  -- now tell all the minions to attack!
  for _,mob in ipairs(mobs) do
    queue_message(mob, self, "attack", {target = target})
    -- also if the parent mob is allied to a player
    -- ally the summoned monsters to the player as well
    mob.allied_to = self.allied_to
  end

  if self.abilities.enters_summon and #mobs > 0 then
    mobs[1].carried_monster = {
      name = self.name,
      hp = self.hp,
      mg_id = self.mg_id
    }
    -- die fast
    hq_clear(self)
  end

  return true
end

local function player_summon(player, mob_name, number, timeout)
  local def = core.registered_entities["mg_mobs:" .. mob_name]
  print('player wants to spawn ' .. number .. ' ' .. mob_name)
  local mob_flies = def.behaviors and def.behaviors.flies

  local locations = ai_tools.find_loc(
    player:get_pos(),
    1,5,
    not mob_flies,
    number
  )

  for _, pos in ipairs(locations) do
    -- players spawned mobs do not collide with
    -- objects so they don't get the player stuck
    local obj = spawn(pos, mob_name)
    obj:set_properties({
      collide_with_objects = false
    })
    local mob = obj:get_luaentity()
    mob.allied_to = player:get_player_name()
    mob.leader_id = player:get_player_name()
    if timeout and timeout > 0 then
      mob.timeout = timeout
    end
  end
end


return {
  uuid = ai_tools.uuid,
  spawn = spawn,
  spawn_monsters = spawnMonsters,
  summon_horde = summon_horde,
  queue_message = queue_message,
  player_summon = player_summon,
  hq_clear = hq_clear
}

