core.register_entity("mg_mobs:troll",{
  initial_properties = {
    physical = true,
    stepheight = 0.1,				--EVIL!
    collide_with_objects = true,
    collisionbox = {-0.25, -0.01, -0.25, 0.25, 1.7, 0.25},
    visual = "mesh",
    mesh = "troll_model.x",
    textures = {
      "lottmobs_battle_troll.png",
    },
    visual_size = {x=6, y=6},
    static_save = true,
    makes_footstep_sound = true,
  },
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.4,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10,			-- seconds
  max_hp = 65,

  -- crazy fast regen
  regen = 2,
  defense = 70,
  accuracy = 125,
  attack={range=1,damage_groups={fleshy=2, fleshy_max=15}},
  sounds = {
    warn='mobs_mc_zombiepig_war_cry',
    hurt = 'mobs_mc_zombiepig_hurt',
  },
  animation = {
    stand={range={x=0,y=19},speed=30,loop=true},
    walk={range={x=20,y=35},speed=30,loop=true},
    run={range={x=15,y=15},speed=30,loop=true},
    punch={range={x=36,y=48},speed=30,loop=true},
  },

  bolts = { },
  behaviors = { },
  abilities = {
    avoids_corridors = 1,
    attacks_stagger = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:troll", "Troll", 1);
