local function add_spawner(obj, color)
	local d = 0.2
	local pos = obj:get_pos()
	core.add_particlespawner({
		amount = 1,
		time = 1,
		minpos = {x=pos.x-d, y=pos.y+1, z=pos.z-d},
		maxpos = {x=pos.x+d, y=pos.y+2, z=pos.z+d},
		minvel = {x=-0.1, y=0, z=-0.1},
		maxvel = {x=0.1, y=0.1, z=0.1},
		minacc = {x=-0.1, y=0, z=-0.1},
		maxacc = {x=0.1, y=.1, z=0.1},
		minexptime = 0.5,
		maxexptime = 1,
		minsize = 0.5,
		maxsize = 1,
		collisiondetection = false,
		vertical = false,
		texture = "mcl_particles_effect.png^[colorize:"..color..":127",
	})
end

local particle_color = "#3A8AC6"

mg_oe.register_effect("protection", {
  icon = "mcl_potions_effect_blindness.png",
  default_data = {
    damage = 0
  },
  on_start = function(def, target, duration, damage)
    local data = def.get_data(target)
    data.duration = duration
    data.damage = damage
    def.set_data(target, data)
  end,
  on_step = function(_def, target)
    add_spawner(target, particle_color)
  end
})

local function apply_protection(target, damage)
  local data = mg_oe.get_effect_data("protection", target)

  if(not data.damage or data.damage == 0 or data.duration == 0) then
    return damage
  end

  local new_damage = data.damage - damage

  if new_damage <= 0 then
    mg_oe.clear_effect("protection", target)
    -- how much damage to apply to the player or mob after they 
    -- break through the protection shield
    return new_damage * -1
  end

  data.damage = new_damage
  mg_oe.set_effect_data("protection", target, data)

  -- how much damage to apply to the player or mob
  return 0
end

mg_oe.apply_protection = apply_protection

