local core, nc
    = core, nc

local modname = core.get_current_modname()

include("paint")

local shapes = {
	{name = "Bell", size = 1/4},
	{name = "Cup", size = 1/4},
	{name = "Rosette", size = 1/4},
	{name = "Cluster", param2 = 2, size = 3/8},
	{name = "Star", param2 = 4, size = 3/8},
}
local colors = {
	{name = "Pink", color = "d23379"},
	{name = "Red", color = "d80000"},
	{name = "Orange", color = "c16100"},
	{name = "Yellow", color = "baba00"},
	{name = "White", color = "adadad"},
	{name = "Azure", color = "39849b"},
	{name = "Blue", color = "2424fe"},
	{name = "Violet", color = "5900b2"},
	{name = "Black", color = "202020"},
}

local dye_counts = {
	{name = "Bell", count = 2},
	{name = "Cup", count = 2},
	{name = "Rosette", count = 3},
	{name = "Cluster", count = 3},
	{name = "Star", count = 4},
}



local function reg_dye(colorid)
	local color = colors[colorid]

	core.register_craftitem(modname .. ":dye_" .. colorid, {
		description = color.name .. " Dye",
		inventory_image = modname .. "_dye.png^[multiply:#" .. color.color,
		groups = {flammable = 1},
		sounds = nc.sounds("nc_terrain_crunchy"),
	})
end

local function reg_write(colorid)
end

local function reg_craft_dye(colorid, shapeid)
	local color = colors[colorid]
	local shape = shapes[shapeid]

	local flower = "nc_flora:flower_" .. shapeid .. "_" .. colorid

	nc.register_craft({
		label = color.name .. " " .. shape.name .. " flower to dye",
		action = "pummel",
		toolgroups = {thumpy = 1},
		indexkeys = {flower},
		nodes = {
			{match = flower, replace = "air"},
		},
		items = {
			{name = modname .. ":dye_" .. colorid, count = dye_counts[shapeid].count},
		},
	})
end

for colorid=1,9 do
	reg_dye(colorid)

	for shapeid=1,5 do
		reg_craft_dye(colorid, shapeid)
	end
end
