local core, nc
    = core, nc
local string_gsub
    = string.gsub

local modname = core.get_current_modname()

local colors = {
	{name = "Pink", color = "d23379", opacity = 36},
	{name = "Red", color = "d80000", opacity = 28},
	{name = "Orange", color = "c16100", opacity = 30},
	{name = "Yellow", color = "baba00", opacity = 28},
	{name = "White", color = "adadad", opacity = 30},
	{name = "Azure", color = "39849b", opacity = 36},
	{name = "Blue", color = "2424fe", opacity = 30},
	{name = "Violet", color = "5900b2", opacity = 30},
	{name = "Black", color = "202020", opacity = 34},
}

local function reg_paint(colorid)
	local color = colors[colorid]
	local overlay = modname .. ":overlay_" .. colorid

	local desc = color.name .. " Paint"

	core.register_node(overlay, {
		description = desc,
		tiles = {modname .. "_white.png^[multiply:#" .. color.color .. "^[opacity:" .. color.opacity},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		node_box = nc.fixedbox(
			{-0.5, -0.5, -63/128, 0.5, 0.5, -15/32}
		),
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		walkable = false,
		buildable_to = true,
		pointable = false,
		groups = {
			flammable = 1,
		},
		floodable = true,
		sounds = nc.sounds("nc_terrain_crunchy"),
		on_node_touchthru = function(pos, node, under, player)
			local raw = nc.touchtip_node(under, nil, player)
			if raw and vector.equals(vector.subtract(under, pos),
				nc.facedirs[node.param2].f) then
				return desc .. string_gsub(raw, "^ +", "")
			end
			return raw
		end,
		on_falling_check = function(pos, node)
			local dp = vector.add(pos, nc.facedirs[node.param2].f)
			if not nc.writing_writable(dp, nil, true) then
				core.remove_node(pos)
				return true
			end
			return false
		end,
	})

	nc.register_craft({
		label = "paint with " .. color.name .. " dye",
		action = "pummel",
		pumparticles = {
			minsize = 1,
			maxsize = 5,
			--[[
			forcetexture = "nc_fire_coal_4.png^[resize:16x16^[mask:[combine\\:16x16\\:"
			.. math_floor(math_random() * 12) .. ","
			.. math_floor(math_random() * 12) .. "=nc_api_pummel.png"
			]]--
		},
		duration = 2,
		wield = {name = modname .. ":dye_" .. colorid, count = false},
		consumewield = 1,
		check = function(pos, data)
			return nc.writing_writable(pos)
			and core.get_node(data.pointed.above).name == "air"
		end,
		nodes = {{match = {walkable = true}}},
		after = function(pos, data)
			local dir = vector.subtract(data.pointed.above, data.pointed.under)
			return nc.set_loud(data.pointed.above, {
				name = overlay,
				param2 = core.dir_to_facedir(dir, true),
			})
		end
	})
end

for colorid=1,9 do
	reg_paint(colorid)
end
