local core, nc
    = core, nc

local modname = core.get_current_modname()

local tt = "nc_woodwork_frame.png^(nc_tree_tree_top.png^[mask:nc_woodwork_ladder_mask.png)"

local lt = 1/16
local ll = 1/2
local lw = 6/16

core.register_node(modname .. ":plus_wooden", {
	description = "Wooden Framework",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
			{-lt, -ll, -ll, lt, ll, -lw},
			{-ll, -lt, -ll, ll, lt, -lw},
		},
	},
	tiles = {tt},
	groups = {
		snappy = 1,
		flammable = 2,
		fire_fuel = 1,
		optic_opaque = 1,
		nc_api_rotate_under = 1,
	},
	paramtype = "light",
	climbable = true,
	sunlight_propagates = true,
	sounds = nc.sounds("nc_tree_sticky"),
	mapcolor = {r = 79, g = 54, b = 31, a = 128},
	paramtype2 = "facedir",
	on_rightclick = nc.rotation_on_rightclick,
	nc_param2_equivalent = function(a, b)
		return vector.equals(a.f, b.f)
	end,
})

nc.register_craft({
	label = "wooden frame to framework",
	action = "pummel",
	toolgroups = {choppy = 1},
	indexkeys = {"nc_woodwork:frame"},
	nodes = {
		{match = "nc_woodwork:frame", replace = modname .. ":plus_wooden"},
	},
	items = {
		{name = "nc_tree:stick", count = 2, scatter = 3},
	},
})

nc.register_craft({
	label = "wooden framework recycle",
	action = "pummel",
	toolgroups = {choppy = 1},
	indexkeys = {modname .. ":plus_wooden"},
	nodes = {
		{match = modname .. ":plus_wooden", replace = "air"},
	},
	items = {
		{name = "nc_tree:stick", count = 2, scatter = 3},
	},
})
