bounty = {}
bounty.file = core.get_worldpath() .. '/bounty.txt'
bounty.data = {}
--bounty.prizes = false --determines if prizes or amount per points game-mechanic is used
if false then
    bounty.prizes = 'default:steel_ingot'
    bounty.points_per_prize = 100 --per 100 points you get a default:steel_ingot
else
    bounty.prizes = {
        [20] = 'default:wood 50',        -- for bounties that are higher then 100 iron ingots are given
        [50] = 'default:cobble 50',      -- for bounties that are higher then 150 gold ingots are given
        [70] = 'default:stone 40',       -- for bounties that are higher then 150 gold ingots are given
        [100] = 'default:steel_ingot 2', -- for bounties that are higher then 150 gold ingots are given
        [200] = 'default:steel_ingot 5'  -- etc...
    }
end

bounty.penalize = function(player_name) --set the penalty
    --example of a penalty (revoke all privs ecept interact)
    core.set_player_privs(player_name, { shout = true })
    bounty.unregister(player_name)
    --end of example
end

bounty.load = function()
    local data_file = io.open(bounty.file, 'r')
    if data_file then
        local data_stri = data_file:read();
        bounty.data = core.parse_json(data_stri)
        if bounty.data == nil then
            bounty.data = {}
        end
        data_file:close()
    end
end
bounty.load()

bounty.save = function()
    local data_stri = core.write_json(bounty.data)
    local data_file = io.open(bounty.file, 'w')
    if data_file ~= nil then
        data_file:write(data_stri)
        data_file:close()
    else
        core.log('error', '[bounty] Could not open ' .. bounty.file .. ' with write permission')
    end
end

bounty.increase = function(player_name, amount)
    if bounty.data[player_name] then
        bounty.data[player_name] = bounty.data[player_name] + amount
    else
        bounty.register(player_name, amount)
    end
    bounty.save()
    bounty.notify(player_name, amount)
end

bounty.decrease = function(player_name, amount)
    if bounty.data[player_name] then
        if bounty.data[player_name] - amount < 0 then
        else
            bounty.data[player_name] = bounty.data[player_name] - amount
        end
    end
    bounty.notify(player_name, -amount)
    bounty.save()
end

bounty.register = function(player_name, amount)
    bounty.data[player_name] = amount
    bounty.save()
end

bounty.unregister = function(player_name)
    if bounty.data[player_name] then
        bounty.data[player_name] = nil
        bounty.save()
    end
end

bounty.notify = function(player_name, amount)
    if bounty.data[player_name] + amount <= 0 then
        core.chat_send_all(player_name .. " no longer has a bounty")
    end
    if type(bounty.prizes) == 'string' then
        core.chat_send_all(player_name .. "'s bounty is equal to " .. bounty.get_player_bounty(player_name))
    else
        for key, value in pairs(bounty.prizes) do
            if bounty.data[player_name] > key and bounty.data[player_name] - amount < key then
                core.chat_send_all(player_name .. "'s bounty has changed to " ..
                    bounty.get_player_bounty(player_name))
                break
            end
        end
    end
end

bounty.drop_prize = function(player)
    local player_name = player:get_player_name()
    local prize = bounty.get_player_bounty(player_name)
    core.log('info', prize)
    core.item_drop(ItemStack(prize), player, player:get_pos())
    core.log('info', prize)
    bounty.penalize(player_name)
end

bounty.get_player_bounty = function(player_name)
    local prize = ' has griefed a little bit'
    if type(bounty.prizes) == 'string' then
        local amount = math.floor(bounty.data[player_name] / bounty.points_per_prize)
        if bounty.data[player_name] >= bounty.points_per_prize then
            prize = bounty.prizes .. ' ' .. amount
        end
    else
        local order = 0
        for key, value in pairs(bounty.prizes) do
            if order < key and bounty.data[player_name] > key then
                order = key
                prize = bounty.prizes[key]
            end
        end
    end
    return prize
end

--chatcommands for testing purposes
core.register_chatcommand('bounty', {
    params = '',
    description = 'Place bounty on offenders and increasing the bounty by 20',
    privs = { interact = true },
    func = function(name, params)
        bounty.increase(name, 20)
    end
})

core.register_chatcommand('forgive', {
    params = '',
    description = 'Forgive offender and decrease bounty by 20',
    privs = { interact = true },
    func = function(name, params)
        bounty.decrease(name, 20)
    end
})

core.register_chatcommand('bounties', {
    params = '',
    description = 'Show all offenders and their bounty',
    privs = { interact = true },
    func = function(name, params)
        for key, value in pairs(bounty.data) do
            core.chat_send_player(name, key .. ' - ' .. bounty.get_player_bounty(key))
        end
    end
})

core.register_on_dieplayer(function(player)
    if bounty.data[player:get_player_name()] then --check if is perpetrator
        bounty.drop_prize(player)
    end
end)
