---------------------------------------------------------------------------------------
-- simple anvil that can be used to repair tools
---------------------------------------------------------------------------------------
-- * can be used to repair tools
-- * the hammer gets damaged a bit at each repair step
---------------------------------------------------------------------------------------

metalworking = {
	config = {
		-- time after which the knapping process gets aborted,
		-- to prevent players from cluttering a world with thousands of entities
		timeout = core.settings:get("metalworking_timeout") or 600,
		-- how many knapping processes can run simultaneously,
		-- again, to prevent players from cluttering a world with entities
		max_crafts = core.settings:get("metalworking_max_crafts") or 25,
		hammer_repairable = core.settings:get_bool("metalworking_hammer_is_repairable", true),
		hud_timeout = 2, -- seconds
		item_displacement = 2 / 16,
	},
	path = core.get_modpath('metalworking'),
	registered_recipes = {},
	registered_callbacks = {
		forge_weld = {}
	},
	crafting_processes = {},
	registered_hammers = {},
	registered_anvils = {},
}

core.register_alias("castle:anvil", "metalworking:steel_anvil")
core.register_alias('metalworking:steel_anvil', "metalworking:steel_anvil")

dofile(metalworking.path .. '/materials.lua')
dofile(metalworking.path .. '/tools.lua')
dofile(metalworking.path .. '/functions.lua')
dofile(metalworking.path .. '/registration.lua')
dofile(metalworking.path .. '/crafts.lua')

if core.get_modpath("technic") then
	dofile(metalworking.path .. '/technic_interop.lua')
end
