local S = core.get_translator(core.get_current_modname())

-- the hammer for the anvil

metalworking.register_hammer("metalworking:stone_hammer", {
    description = S("Stone Blacksmithing Hammer"),
    image = "anvil_tool_stonehammer.png",
    tool_capabilities = {
        full_punch_interval = 0.8,
        max_drop_level = 1,
        groupcaps = {
            -- about equal to a stone pick (it's not intended as a tool)
            cracky = { times = { [2] = 2.00, [3] = 1.20 }, uses = 10, maxlevel = 1 },
        },
        damage_groups = { fleshy = 6 },
    }
})

metalworking.register_hammer("metalworking:desert_stone_hammer", {
    description = S("Desert Stone Blacksmithing Hammer"),
    image = "anvil_tool_desert_stonehammer.png",
    tool_capabilities = {
        full_punch_interval = 0.8,
        max_drop_level = 1,
        groupcaps = {
            -- about equal to a stone pick (it's not intended as a tool)
            cracky = { times = { [2] = 2.00, [3] = 1.20 }, uses = 10, maxlevel = 1 },
        },
        damage_groups = { fleshy = 6 },
    }
})

metalworking.register_hammer("metalworking:bronze_hammer", {
    description = S("Bronze Blacksmithing Hammer"),
    image = "anvil_tool_bronzehammer.png",
    tool_capabilities = {
        full_punch_interval = 0.8,
        max_drop_level = 1,
        groupcaps = {
            -- about equal to a stone pick (it's not intended as a tool)
            cracky = { times = { [2] = 2.00, [3] = 1.20 }, uses = 20, maxlevel = 1 },
        },
        damage_groups = { fleshy = 6 },
    }
})

metalworking.register_hammer("metalworking:steel_hammer", {
    description = S("Steel Blacksmithing Hammer"),
    image = "anvil_tool_steelhammer.png",
    tool_capabilities = {
        full_punch_interval = 0.8,
        max_drop_level = 1,
        groupcaps = {
            -- about equal to a stone pick (it's not intended as a tool)
            cracky = { times = { [2] = 2.00, [3] = 1.20 }, uses = 30, maxlevel = 1 },
        },
        damage_groups = { fleshy = 6 },
    }
})

-- the anvil

metalworking.register_anvil('metalworking:stone_anvil', {
    description = S("Stone Anvil"),
    _doc_items_longdesc = S("A tool for repairing other tools in conjunction with a blacksmith's hammer."),
    _doc_items_usagehelp = S("Right-click on this anvil with a damaged tool to place the damaged tool upon it. " ..
        "You can then repair the damaged tool by striking it with a blacksmith's hammer. " ..
        "Repeated blows may be necessary to fully repair a badly worn tool. " ..
        "To retrieve the tool either punch or right-click the anvil with an empty hand."),
    tiles = { "default_stone.png" },
    groups = { cracky = 1 },
})

metalworking.register_anvil('metalworking:desert_stone_anvil', {
    description = S("Desert Stone Anvil"),
    _doc_items_longdesc = S("A tool for repairing other tools in conjunction with a blacksmith's hammer."),
    _doc_items_usagehelp = S("Right-click on this anvil with a damaged tool to place the damaged tool upon it. " ..
        "You can then repair the damaged tool by striking it with a blacksmith's hammer. " ..
        "Repeated blows may be necessary to fully repair a badly worn tool. " ..
        "To retrieve the tool either punch or right-click the anvil with an empty hand."),
    tiles = { "default_desert_stone.png" },
    groups = { cracky = 1 },
})

metalworking.register_anvil('metalworking:bronze_anvil', {
    description = S("Bronze Anvil"),
    _doc_items_longdesc = S("A tool for repairing other tools in conjunction with a blacksmith's hammer."),
    _doc_items_usagehelp = S("Right-click on this anvil with a damaged tool to place the damaged tool upon it. " ..
        "You can then repair the damaged tool by striking it with a blacksmith's hammer. " ..
        "Repeated blows may be necessary to fully repair a badly worn tool. " ..
        "To retrieve the tool either punch or right-click the anvil with an empty hand."),
    tiles = { "default_bronze_block.png" },
    groups = { cracky = 2 },
})

metalworking.register_anvil('metalworking:unheated_steel_anvil', {
    description = S("Not Heat Treated Steel Anvil"),
    _doc_items_longdesc = S("Needs to be heat-treated"),
    _doc_items_usagehelp = S("Cook it in a furnace to heat treat it."),
    tiles = { "default_steel_block.png" },
    groups = { cracky = 2 },
})

metalworking.register_anvil('metalworking:steel_anvil', {
    description = S("Heat Treated Steel Anvil"),
    _doc_items_longdesc = S("A tool for repairing other tools in conjunction with a blacksmith's hammer."),
    _doc_items_usagehelp = S("Right-click on this anvil with a damaged tool to place the damaged tool upon it. " ..
        "You can then repair the damaged tool by striking it with a blacksmith's hammer. " ..
        "Repeated blows may be necessary to fully repair a badly worn tool. " ..
        "To retrieve the tool either punch or right-click the anvil with an empty hand."),
    tiles = { "default_steel_block.png^[colorize:#000000:100" },
    groups = { cracky = 2 },
})

core.register_craftitem('metalworking:stone_hammer_head', {
    description = 'Stone Blacksmithing Hammer Head',
    inventory_image = 'stone_hammer_head.png'
})

core.register_craftitem('metalworking:desert_stone_hammer_head', {
    description = 'Desert Stone Blacksmithing Hammer Head',
    inventory_image = 'desert_stone_hammer_head.png'
})

core.register_craftitem('metalworking:bronze_hammer_head', {
    description = 'Bronze Blacksmithing Hammer Head',
    inventory_image = 'bronze_hammer_head.png'
})

core.register_craftitem('metalworking:bronze_sword_head', {
    description = 'Bronze Blacksmithing Sword Blade',
    inventory_image = 'tinkering_sword_blade.png'..'^[multiply:'..metalworking.materials.bronze.color
})

core.register_craftitem('metalworking:bronze_pick_head', {
    description = 'Bronze Blacksmithing Pickaxe Head',
    inventory_image = 'tinkering_pickaxe_head.png'..'^[multiply:'..metalworking.materials.bronze.color
})

core.register_craftitem('metalworking:bronze_axe_head', {
    description = 'Bronze Blacksmithing Axe Head',
    inventory_image = 'tinkering_axe_head.png'..'^[multiply:'..metalworking.materials.bronze.color
})

core.register_craftitem('metalworking:bronze_shovel_head', {
    description = 'Bronze Blacksmithing Shovel Head',
    inventory_image = 'tinkering_shovel_head.png'..'^[multiply:'..metalworking.materials.bronze.color
})

core.register_craftitem('metalworking:steel_hammer_head', {
    description = 'Steel Blacksmithing Hammer Head',
    inventory_image = 'steel_hammer_head.png'
})

core.register_craftitem('metalworking:steel_sword_head', {
    description = 'Steel Blacksmithing Sword Blade',
    inventory_image = 'tinkering_sword_blade.png'..'^[multiply:'..metalworking.materials.steel.color
})

core.register_craftitem('metalworking:steel_pick_head', {
    description = 'Steel Blacksmithing Pickaxe Head',
    inventory_image = 'tinkering_pickaxe_head.png'..'^[multiply:'..metalworking.materials.steel.color
})

core.register_craftitem('metalworking:steel_axe_head', {
    description = 'Steel Blacksmithing Axe Head',
    inventory_image = 'tinkering_axe_head.png'..'^[multiply:'..metalworking.materials.steel.color
})

core.register_craftitem('metalworking:steel_shovel_head', {
    description = 'Steel Blacksmithing Shovel Head',
    inventory_image = 'tinkering_shovel_head.png'..'^[multiply:'..metalworking.materials.steel.color
})

if core.get_modpath('pigiron') then
    metalworking.register_hammer("metalworking:hammer_iron", {
        description = S("Iron Blacksmithing Hammer"),
        image = "anvil_tool_steelhammer.png",
        tool_capabilities = {
            full_punch_interval = 0.8,
            max_drop_level = 1,
            groupcaps = {
                -- about equal to a stone pick (it's not intended as a tool)
                cracky = { times = { [2] = 2.00, [3] = 1.20 }, uses = 25, maxlevel = 1 },
            },
            damage_groups = { fleshy = 6 },
        }
    })

    core.register_craftitem('metalworking:iron_hammer_head', {
        description = 'Iron Blacksmithing Hammer Head',
        inventory_image = 'iron_hammer_head.png'
    })
end
