if core.registered_items['default:string'] then
	local def = table.copy(core.registered_items['default:string'])
	def.groups = def.groups or {}
	def.groups.grass = 1
	core.override_item('default:string', def)
end
---------------------------------------------------------------------------------------
-- crafting receipes
---------------------------------------------------------------------------------------
core.register_craft({
	type = "cooking",
	output = 'metalworking:steel_anvil',
	recipe = 'metalworking:unheated_steel_anvil',
	cooktime = 10.0
})

core.register_craft({
	output = 'metalworking:unheated_steel_anvil',
	recipe = {
		{ "default:steel_ingot", "default:steel_ingot", "default:steel_ingot" },
		{ "",                    "default:steel_ingot", "" },
		{ "default:steel_ingot", "default:steel_ingot", "default:steel_ingot" }
	}
})

core.register_craft({
	output = 'metalworking:bronze_anvil',
	recipe = {
		{ "default:bronze_ingot", "default:bronze_ingot", "default:bronze_ingot" },
		{ "",                     "default:bronze_ingot", "" },
		{ "default:bronze_ingot", "default:bronze_ingot", "default:bronze_ingot" }
	}
})

core.register_craft({
	type = 'shapeless',
	output = "metalworking:stone_hammer",
	recipe = {
		'metalworking:stone_hammer_head',
		'group:string',
		"group:stick"
	}
})

core.register_craft({
	type = 'shapeless',
	output = "metalworking:desert_stone_hammer",
	recipe = {
		'metalworking:desert_stone_hammer_head',
		'group:string',
		"group:stick"
	}
})

local anvil_knapping_recipe = {
	{ 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 0, 0, 1, 1, 1, 1, 0, 0 },
	{ 0, 0, 1, 1, 1, 1, 0, 0 },
	{ 0, 1, 1, 1, 1, 1, 1, 0 },
	{ 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 0, 0, 0, 0, 0, 0, 0, 0 },
}

local hammer_knapping_recipe = {
	{ 0, 0, 0, 1, 0, 0, 0, 0 },
	{ 0, 0, 1, 1, 0, 0, 0, 0 },
	{ 0, 1, 1, 1, 1, 1, 0, 0 },
	{ 1, 1, 1, 1, 1, 1, 0, 0 },
	{ 0, 0, 1, 1, 1, 1, 1, 1 },
	{ 0, 0, 0, 1, 1, 1, 1, 0 },
	{ 0, 0, 0, 0, 1, 1, 0, 0 },
	{ 0, 0, 0, 0, 1, 0, 0, 0 },
}

knapping.register_recipe({
	input = core.global_exists('quarry') and "quarry:cut_stone" or "default:stone",
	output = "metalworking:stone_anvil",
	recipe = anvil_knapping_recipe,
	texture = 'default_stone.png'
})

knapping.register_recipe({
	input = core.global_exists('quarry') and "quarry:cut_desert_stone" or "default:desert_stone",
	output = "metalworking:desert_stone_anvil",
	recipe = anvil_knapping_recipe,
	texture = 'default_desert_stone.png'
})

knapping.register_recipe({
	input = core.global_exists('quarry') and "quarry:cut_stone" or "default:stone",
	output = "metalworking:stone_hammer_head",
	recipe = hammer_knapping_recipe,
	texture = 'default_stone.png'
})

knapping.register_recipe({
	input = core.global_exists('quarry') and "quarry:cut_desert_stone" or "default:desert_stone",
	output = "metalworking:desert_stone_hammer_head",
	recipe = hammer_knapping_recipe,
	texture = 'default_desert_stone.png'
})

for material, mdata in pairs(metalworking.materials) do
	if mdata.forge_weld then
		for tool, tdata in pairs(metalworking.tools) do
			metalworking.register_craft({
				type = 'forge_weld',
				input = mdata.default,
				output = 'metalworking:' .. material .. '_' .. tool .. '_head',
				recipe = tdata.recipe
			})

			local tool_name = string.gsub(mdata.default, ':.+', '') .. ':' .. tool .. '_' .. material
			
			core.clear_craft({ output = tool_name })
			core.register_craft({
				type = 'shapeless',
				output = tool_name,
				recipe = {
					'metalworking:' .. material .. '_' .. tool .. '_head',
					'group:string',
					'group:stick',
				}
			})
		end
	end
end
