core.clear_craft({ output = 'sleeping_mat:mat' })

core.register_craft({
	output = "sleeping_mat:mat",
	type = "shapeless",
	recipe = {
		"group:grass", "group:grass", "group:grass",
		"group:grass", "group:grass", "group:grass"
	},
})

if core.global_exists('animalia') then
	local campfire_cookable = {
		"animalia:song_bird_egg", "animalia:chicken_egg", "animalia:turkey_egg",
		'animalia:poultry_raw', "animalia:venison_raw", "animalia:porkchop_raw",
		"animalia:rat_raw", "animalia:mutton_raw", "animalia:beef_raw",
	}
	for _, item in ipairs(campfire_cookable) do
		local groups = core.registered_items[item].groups
		groups.campfire_cookable = 1
		core.override_item(item, {
			groups = groups
		})
	end
end

if core.global_exists('charcoal') then
	core.override_item('charcoal:charcoal', {
		groups = { coal = 1, flammable = 1 }
	})
end

if core.registered_items['pigiron:charcoal_lump'] and core.global_exists('charcoal') then
	core.clear_craft({ output = 'pigiron:charcoal_lump' })
	core.clear_craft({
		recipe = {
			{ "pigiron:charcoal_lump" },
			{ "group:stick" }
		}
	})
	core.register_alias_force('pigiron:charcoal_lump', 'charcoal:charcoal')

	core.override_item('pigiron:iron_charcoal_mix', {
		inventory_image = "pigiron_iron_ingot.png^charcoal_charcoal.png"
	})
end

-- core.register_on_mods_loaded(function()
-- 	if core.global_exists('beds') then
-- 		if core.global_exists('emote') then
-- 			for node_name, def in pairs(core.registered_nodes) do
-- 				if def.groups and def.groups.bed then
-- 					core.override_item(node_name, {
-- 						on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
-- 							emote.start(clicker, 'lay')
-- 							def.on_rightclick(pos, node, clicker, itemstack, pointed_thing)
-- 							emote.stop(clicker)
-- 							return pointed_thing
-- 						end
-- 					})
-- 				end
-- 			end
-- 		end
-- 	end
-- end)
