core.register_node("stoneage:torch_unlit", {
	description = "Torch",
	drawtype = "torchlike",
	tiles = { "stoneage_torch_unlit_on_floor.png", "stoneage_torch_unlit_on_ceiling.png", "stoneage_torch_unlit_on_wall.png" },
	inventory_image = "stoneage_torch_unlit_on_floor.png",
	wield_image = "stoneage_torch_unlit_on_floor.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	selection_box = {
		type = "wallmounted",
		wall_top = { -0.1, 0.5 - 0.6, -0.1, 0.1, 0.5, 0.1 },
		wall_bottom = { -0.1, -0.5, -0.1, 0.1, -0.5 + 0.6, 0.1 },
		wall_side = { -0.5, -0.3, -0.1, -0.5 + 0.3, 0.3, 0.1 },
	},
	groups = { choppy = 2, dig_immediate = 3, flammable = 1, attached_node = 1, campfire_cookable = 1 },

	-- lighting a placed torch when hit by a buring one
	after_dig_node = function(pos, node, oldmetadata, puncher)
		local wield = puncher:get_wielded_item():get_name()
		if wield == "default:torch" then
			node.name = "default:torch"
			core.set_node(pos, node)
			local inv = puncher:get_inventory()
			inv:remove_item("main", "stoneage:torch_unlit")
		end
	end,

	-- lighting the torch in hand when hitting a burning one
	on_use = function(itemstack, user, pointed_thing)
		if pointed_thing.type == "node" then
			local n = core.get_node(pointed_thing.under)
			if core.get_item_group(n.name, "igniter") ~= 0 or n.name == "default:torch" or n.name == "default:furnace_active" then
				local torch_count = user:get_wielded_item():get_count()
				itemstack:replace("default:torch " .. torch_count .. "")
				return itemstack
			else
				core.punch_node(pointed_thing.under)
			end
		else
			return
		end
	end,

	sounds = stoneage.sounds.torch_unlit,
})

--
-- ores
--

core.register_node("stoneage:grass_with_silex", {
	description = "Silex",
	tiles = { "default_grass.png^stoneage_silex_ore.png", "default_dirt.png^stoneage_silex_ore.png", "default_dirt.png^default_grass_side.png^stoneage_silex_ore.png" },
	is_ground_content = true,
	groups = { crumbly = 3, soil = 1 },
	drop = 'stoneage:silex',
	sounds = stoneage.sounds.grass_with_silex,
})

core.register_node("stoneage:dirt_with_silex", {
	description = "Silex",
	tiles = { "default_dirt.png^stoneage_silex_ore.png" },
	is_ground_content = true,
	groups = { crumbly = 3, soil = 1 },
	drop = 'stoneage:silex',
	sounds = stoneage.sounds.dirt_with_silex,
})

core.register_node("stoneage:sand_with_silex", {
	description = "Silex",
	tiles = { "default_sand.png^stoneage_silex_ore.png" },
	is_ground_content = true,
	groups = { crumbly = 3, falling_node = 1 },
	drop = 'stoneage:silex',
	sounds = stoneage.sounds.sand_with_silex,
})

-----------------------------------------------------------------------------------------------
-- Dry Plants - Resin 0.0.2 (not in use)
-----------------------------------------------------------------------------------------------
-- by Mossmanikin
-- License (everything): 	WTFPL
-- Looked at code from:		default, plants_lib, trees				
-----------------------------------------------------------------------------------------------

-----------------------------------------------------------------------------------------------
-- Resin
-----------------------------------------------------------------------------------------------
core.register_node("stoneage:resin", {
	description = "Resin",
	drawtype = "signlike",
	tile_images = { "dryplants_resin.png" },
	inventory_image = "dryplants_resin.png",
	wield_image = "dryplants_resin.png",
	sunlight_propagates = true,
	paramtype = "light",
	paramtype2 = "wallmounted",
	walkable = false,
	groups = { snappy = 3 },
	sounds = xcompat.sounds.node_sound_leaves_defaults(),
	selection_box = {
		type = "wallmounted",
	},
	buildable_to = true
})

-----------------------------------------------------------------------------------------------
-- Fur Cover
-----------------------------------------------------------------------------------------------
if (core.get_modpath("animalmaterials")) ~= nil then
	core.register_node("stoneage:fur", {
		description = "Fur Cover",
		inventory_image = "animalmaterials_fur.png",
		wield_image = "animalmaterials_fur.png",
		drawtype = "signlike",
		tiles = { "animalmaterials_fur.png" },
		paramtype = "light",
		paramtype2 = "wallmounted",
		--paramtype2 = "facedir",
		sunlight_propagates = true,
		walkable = false,
		selection_box = {
			type = "wallmounted",
		},
		groups = { choppy = 2, dig_immediate = 2, attached_node = 1 },
		legacy_wallmounted = true,
	})
	-- craft
	core.register_craft({
		output = 'stoneage:fur',
		recipe = {
			{ 'animalmaterials:fur' },
		}
	})
end

-----------------------------------------------------------------------------------------------
-- Wisent Painting
-----------------------------------------------------------------------------------------------
core.register_node("stoneage:wisent", {
	description = "Wisent Painting",
	inventory_image = "primitivedeco_wisent.png",
	wield_image = "dye_red.png",
	drawtype = "signlike",
	tiles = { "primitivedeco_wisent.png" },
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	selection_box = {
		type = "wallmounted",
	},
	groups = { choppy = 2, dig_immediate = 2, attached_node = 1 },
	legacy_wallmounted = true,
})

-----------------------------------------------------------------------------------------------
-- local title   = "More Silex"
-- local version = "0.0.4"
-- local mname   = "moresilex"
-----------------------------------------------------------------------------------------------
-- by Mossmanikin
-- License (everything): 	WTFPL
-- Contains code from: 		stoneage
-- Looked at code from:
-- Dependencies: 			stoneage
-- Supports:				
-----------------------------------------------------------------------------------------------

core.register_node("stoneage:desert_sand_with_silex", {
	description = "Silex",
	tiles = { "default_desert_sand.png^stoneage_silex_ore.png" },
	is_ground_content = true,
	groups = { crumbly = 3, falling_node = 1 },
	drop = 'stoneage:silex',
	sounds = xcompat.sounds.node_sound_sand_defaults(),
})

core.register_node("stoneage:gravel_with_silex", {
	description = "Silex",
	tiles = { "default_gravel.png^stoneage_silex_ore.png" },
	is_ground_content = true,
	groups = { crumbly = 3, falling_node = 1 },
	drop = 'stoneage:silex',
	sounds = xcompat.sounds.node_sound_sand_defaults(),
})
