function stoneage.strike_fire(user, pointed_thing)
	local sound_pos = pointed_thing.above or user:get_pos()
	core.sound_play("fire_flint_and_steel",
		{ pos = sound_pos, gain = 0.2, max_hear_distance = 8 }, true)
	local player_name = user:get_player_name()
	if pointed_thing.type == "node" then
		local node_under = core.get_node(pointed_thing.under).name
		local nodedef = core.registered_nodes[node_under]
		if not nodedef then
			return
		end
		if core.is_protected(pointed_thing.under, player_name) then
			core.record_protection_violation(pointed_thing.under, player_name)
			return
		end
		if nodedef.on_ignite then
			nodedef.on_ignite(pointed_thing.under, user)
		elseif core.get_item_group(node_under, "flammable") >= 1
			and core.get_node(pointed_thing.above).name == "air" then
			if core.is_protected(pointed_thing.above, player_name) then
				core.record_protection_violation(pointed_thing.above, player_name)
				return
			end

			core.set_node(pointed_thing.above, { name = "fire:basic_flame" })
		end
	end
	-- if pointed_thing.type == "node" then
	-- 	local n_pointed_above = core.get_node(pointed_thing.above)
	-- 	local n_pointed_under = core.get_node(pointed_thing.under)

	-- 	for _, tinder in ipairs(stoneage.tinder) do
	-- 		if user:get_inventory():get_stack("main", user:get_wield_index() + 1):get_name() == tinder then
	-- 			user:get_inventory():remove_item("main", tinder)
	-- 			if n_pointed_under.name == "stoneage:torch_unlit" then
	-- 				n_pointed_under.name = "default:torch"
	-- 				core.add_node(pointed_thing.under, n_pointed_under)
	-- 			elseif n_pointed_above.name == "air" then
	-- 				core.add_node(pointed_thing.above, { name = "fire:basic_flame" })
	-- 			end
	-- 		end
	-- 	end
		-- if n_pointed_under.name == "campfires:campfire" then
		-- 	core.add_node(pointed_thing.under, { name = "campfires:campfire_lit" })
		-- end
		-- if n_pointed_under.name == "stoneage:torch_unlit" then
		-- 	core.add_node(pointed_thing.under, { name = "default:torch" })
		-- end
	-- else
	-- 	return
	-- end
end

-- torchdecay
-- burntime equals half a night
if stoneage.torchdecay then
	core.register_abm({
		nodenames = { "default:torch" },
		interval = 9,
		chance = 1,
		action = function(pos, node)
			local meta = core.get_meta(pos)
			local decay = meta:get_int("decay")
			if not decay then
				meta:set_int("decay", 1)
				return
			end
			if decay >= math.random(36, 44) then
				node.name = "stoneage:torch_unlit"
				core.add_node(pos, node)
				meta:set_int("decay", 0)
				return
			end
			decay = decay + 1
			meta:set_int("decay", decay)
		end
	})

	core.register_abm({
		nodenames = { "stoneage:bonfire" },
		interval = 18,
		chance = 1,
		action = function(pos, node)
			local meta = core.get_meta(pos)
			local decay = meta:get_int("decay")
			if not decay then
				meta:set_int("decay", 1)
				return
			end
			if decay >= math.random(36, 44) then
				node.name = "stoneage:bonfire_unlit"
				core.add_node(pos, node)
				meta:set_int("decay", 0)
				return
			end
			decay = decay + 1
			meta:set_int("decay", decay)
		end
	})
end

function stoneage.generate_ore(name, wherein, minp, maxp, seed, chunks_per_volume, ore_per_chunk, height_min, height_max)
	if maxp.y < height_min or minp.y > height_max then
		return
	end
	local y_min = math.max(minp.y, height_min)
	local y_max = math.min(maxp.y, height_max)
	local volume = (maxp.x - minp.x + 1) * (y_max - y_min + 1) * (maxp.z - minp.z + 1)
	local pr = PseudoRandom(seed)
	local num_chunks = math.floor(chunks_per_volume * volume)
	local chunk_size = 3
	if ore_per_chunk <= 4 then
		chunk_size = 2
	end
	local inverse_chance = math.floor(chunk_size * chunk_size * chunk_size / ore_per_chunk)
	--print("generate_ore num_chunks: "..dump(num_chunks))
	for i = 1, num_chunks do
		local y0 = pr:next(y_min, y_max - chunk_size + 1)
		if y0 >= height_min and y0 <= height_max then
			local x0 = pr:next(minp.x, maxp.x - chunk_size + 1)
			local z0 = pr:next(minp.z, maxp.z - chunk_size + 1)
			local p0 = { x = x0, y = y0, z = z0 }
			for x1 = 0, chunk_size - 1 do
				for y1 = 0, chunk_size - 1 do
					for z1 = 0, chunk_size - 1 do
						if pr:next(1, inverse_chance) == 1 then
							local x2 = x0 + x1
							local y2 = y0 + y1
							local z2 = z0 + z1
							local p2 = { x = x2, y = y2, z = z2 }
							if core.get_node(p2).name == wherein then
								core.set_node(p2, { name = name })
							end
						end
					end
				end
			end
		end
	end
end
