core.register_on_mods_loaded(function()
	local soil = {}
	local sand = {}

	for node_name, def in pairs(core.registered_nodes) do
		if def.groups then
			if def.groups.soil then
				table.insert(soil, node_name)
			elseif def.groups.sand then
				table.insert(sand, node_name)
			end
		end
	end

	core.register_ore({
		ore_type       = "scatter",
		ore            = "stoneage:dirt_with_silex",
		wherein        = soil,
		clust_scarcity = 19 * 19 * 19,
		clust_num_ores = 5,
		clust_size     = 3,
		y_min     = -8,
		y_max     = 64,
	})

	core.register_ore({
		ore_type       = "scatter",
		ore            = "stoneage:sand_with_silex",
		wherein        = sand,
		clust_scarcity = 17 * 17 * 17,
		clust_num_ores = 8,
		clust_size     = 4,
		y_min     = -63,
		y_max     = -16,
	})
end)

core.register_on_generated(function(minp, maxp, seed)
	stoneage.generate_ore("stoneage:desert_sand_with_silex", "default:desert_sand", minp, maxp, seed + 485,
		1 / 21 / 21 / 21, 11,
		-16, 32)
	stoneage.generate_ore("stoneage:gravel_with_silex", "default:gravel", minp, maxp, seed + 485, 1 / 21 / 21 / 21, 11,
		-16, 32)
end)
